/*
 * Decompiled with CFR 0.152.
 */
package com.google.samples.apps.iosched.shared.di;

import android.content.Context;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.ktx.FirestoreKt;
import com.google.firebase.functions.FirebaseFunctions;
import com.google.firebase.functions.ktx.FunctionsKt;
import com.google.firebase.ktx.Firebase;
import com.google.firebase.remoteconfig.FirebaseRemoteConfig;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.google.firebase.remoteconfig.ktx.RemoteConfigKt;
import com.google.samples.apps.iosched.shared.R;
import com.google.samples.apps.iosched.shared.data.BootstrapConferenceDataSource;
import com.google.samples.apps.iosched.shared.data.ConferenceDataRepository;
import com.google.samples.apps.iosched.shared.data.ConferenceDataSource;
import com.google.samples.apps.iosched.shared.data.NetworkConferenceDataSource;
import com.google.samples.apps.iosched.shared.data.ar.ArDebugFlagEndpoint;
import com.google.samples.apps.iosched.shared.data.ar.DefaultArDebugFlagEndpoint;
import com.google.samples.apps.iosched.shared.data.config.AppConfigDataSource;
import com.google.samples.apps.iosched.shared.data.config.RemoteAppConfigDataSource;
import com.google.samples.apps.iosched.shared.data.db.AppDatabase;
import com.google.samples.apps.iosched.shared.data.feed.AnnouncementDataSource;
import com.google.samples.apps.iosched.shared.data.feed.DefaultFeedRepository;
import com.google.samples.apps.iosched.shared.data.feed.FeedRepository;
import com.google.samples.apps.iosched.shared.data.feed.FirestoreAnnouncementDataSource;
import com.google.samples.apps.iosched.shared.data.feed.FirestoreMomentDataSource;
import com.google.samples.apps.iosched.shared.data.feed.MomentDataSource;
import com.google.samples.apps.iosched.shared.data.feedback.DefaultFeedbackEndpoint;
import com.google.samples.apps.iosched.shared.data.feedback.FeedbackEndpoint;
import com.google.samples.apps.iosched.shared.data.session.DefaultSessionRepository;
import com.google.samples.apps.iosched.shared.data.session.SessionRepository;
import com.google.samples.apps.iosched.shared.data.userevent.DefaultSessionAndUserEventRepository;
import com.google.samples.apps.iosched.shared.data.userevent.FirestoreUserEventDataSource;
import com.google.samples.apps.iosched.shared.data.userevent.SessionAndUserEventRepository;
import com.google.samples.apps.iosched.shared.data.userevent.UserEventDataSource;
import com.google.samples.apps.iosched.shared.di.IoDispatcher;
import com.google.samples.apps.iosched.shared.di.SearchUsingRoomEnabledFlag;
import com.google.samples.apps.iosched.shared.di.SharedModule;
import com.google.samples.apps.iosched.shared.domain.search.FtsMatchStrategy;
import com.google.samples.apps.iosched.shared.domain.search.SessionTextMatchStrategy;
import com.google.samples.apps.iosched.shared.domain.search.SimpleMatchStrategy;
import com.google.samples.apps.iosched.shared.fcm.FcmTopicSubscriber;
import com.google.samples.apps.iosched.shared.fcm.TopicSubscriber;
import com.google.samples.apps.iosched.shared.time.DefaultTimeProvider;
import com.google.samples.apps.iosched.shared.time.TimeProvider;
import com.google.samples.apps.iosched.shared.util.NetworkUtils;
import dagger.Module;
import dagger.Provides;
import dagger.hilt.InstallIn;
import dagger.hilt.android.components.ApplicationComponent;
import dagger.hilt.android.qualifiers.ApplicationContext;
import javax.inject.Named;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;

@Module
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0007J$\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u00142\b\b\u0001\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u001a\u0010\u001b\u001a\u00020\u00142\b\b\u0001\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$H\u0007J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\b\u0010'\u001a\u00020\u0006H\u0007J\b\u0010(\u001a\u00020\u0012H\u0007J\u0010\u0010)\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010*\u001a\u00020\fH\u0007J\u0010\u0010+\u001a\u00020$2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0007J\u0010\u00102\u001a\u0002012\u0006\u00103\u001a\u00020\u0016H\u0007J\u001a\u00104\u001a\u0002052\b\b\u0001\u00106\u001a\u0002072\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\b\u00108\u001a\u000209H\u0007J\b\u0010:\u001a\u00020;H\u0007J\u001a\u0010<\u001a\u00020/2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006="}, d2={"Lcom/google/samples/apps/iosched/shared/di/SharedModule;", "", "()V", "provideAnnouncementDataSource", "Lcom/google/samples/apps/iosched/shared/data/feed/AnnouncementDataSource;", "firestore", "Lcom/google/firebase/firestore/FirebaseFirestore;", "provideAppConfigDataSource", "Lcom/google/samples/apps/iosched/shared/data/config/AppConfigDataSource;", "remoteConfig", "Lcom/google/firebase/remoteconfig/FirebaseRemoteConfig;", "configSettings", "Lcom/google/firebase/remoteconfig/FirebaseRemoteConfigSettings;", "ioDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "provideArDebugFlagEndpoint", "Lcom/google/samples/apps/iosched/shared/data/ar/ArDebugFlagEndpoint;", "functions", "Lcom/google/firebase/functions/FirebaseFunctions;", "provideBootstrapRemoteSessionDataSource", "Lcom/google/samples/apps/iosched/shared/data/ConferenceDataSource;", "provideConferenceDataRepository", "Lcom/google/samples/apps/iosched/shared/data/ConferenceDataRepository;", "remoteDataSource", "boostrapDataSource", "appDatabase", "Lcom/google/samples/apps/iosched/shared/data/db/AppDatabase;", "provideConferenceDataSource", "context", "Landroid/content/Context;", "networkUtils", "Lcom/google/samples/apps/iosched/shared/util/NetworkUtils;", "provideFeedRepository", "Lcom/google/samples/apps/iosched/shared/data/feed/FeedRepository;", "dataSource", "momentsDataSource", "Lcom/google/samples/apps/iosched/shared/data/feed/MomentDataSource;", "provideFeedbackEndpoint", "Lcom/google/samples/apps/iosched/shared/data/feedback/FeedbackEndpoint;", "provideFirebaseFireStore", "provideFirebaseFunctions", "provideFirebaseRemoteConfig", "provideFirebaseRemoteConfigSettings", "provideMomentsDataSource", "provideSessionAndUserEventRepository", "Lcom/google/samples/apps/iosched/shared/data/userevent/SessionAndUserEventRepository;", "userEventDataSource", "Lcom/google/samples/apps/iosched/shared/data/userevent/UserEventDataSource;", "sessionRepository", "Lcom/google/samples/apps/iosched/shared/data/session/SessionRepository;", "provideSessionRepository", "conferenceDataRepository", "provideSessionTextMatchStrategy", "Lcom/google/samples/apps/iosched/shared/domain/search/SessionTextMatchStrategy;", "useRoom", "", "provideTimeProvider", "Lcom/google/samples/apps/iosched/shared/time/TimeProvider;", "provideTopicSubscriber", "Lcom/google/samples/apps/iosched/shared/fcm/TopicSubscriber;", "provideUserEventDataSource", "shared_release"})
@InstallIn(value={ApplicationComponent.class})
public final class SharedModule {
    @Singleton
    @Provides
    @Named(value="remoteConfDatasource")
    @NotNull
    public final ConferenceDataSource provideConferenceDataSource(@ApplicationContext @NotNull Context context, @NotNull NetworkUtils networkUtils) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)networkUtils, (String)"networkUtils");
        return new NetworkConferenceDataSource(context, networkUtils);
    }

    @Singleton
    @Provides
    @Named(value="bootstrapConfDataSource")
    @NotNull
    public final ConferenceDataSource provideBootstrapRemoteSessionDataSource() {
        return BootstrapConferenceDataSource.INSTANCE;
    }

    @Singleton
    @Provides
    @NotNull
    public final ConferenceDataRepository provideConferenceDataRepository(@Named(value="remoteConfDatasource") @NotNull ConferenceDataSource remoteDataSource, @Named(value="bootstrapConfDataSource") @NotNull ConferenceDataSource boostrapDataSource, @NotNull AppDatabase appDatabase) {
        Intrinsics.checkParameterIsNotNull((Object)remoteDataSource, (String)"remoteDataSource");
        Intrinsics.checkParameterIsNotNull((Object)boostrapDataSource, (String)"boostrapDataSource");
        Intrinsics.checkParameterIsNotNull((Object)((Object)appDatabase), (String)"appDatabase");
        return new ConferenceDataRepository(remoteDataSource, boostrapDataSource, appDatabase);
    }

    @Singleton
    @Provides
    @NotNull
    public final AnnouncementDataSource provideAnnouncementDataSource(@NotNull FirebaseFirestore firestore) {
        Intrinsics.checkParameterIsNotNull((Object)firestore, (String)"firestore");
        return new FirestoreAnnouncementDataSource(firestore);
    }

    @Singleton
    @Provides
    @NotNull
    public final MomentDataSource provideMomentsDataSource(@NotNull FirebaseFirestore firestore) {
        Intrinsics.checkParameterIsNotNull((Object)firestore, (String)"firestore");
        return new FirestoreMomentDataSource(firestore);
    }

    @Singleton
    @Provides
    @NotNull
    public final FeedRepository provideFeedRepository(@NotNull AnnouncementDataSource dataSource, @NotNull MomentDataSource momentsDataSource) {
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)momentsDataSource, (String)"momentsDataSource");
        return new DefaultFeedRepository(dataSource, momentsDataSource);
    }

    @Singleton
    @Provides
    @NotNull
    public final SessionRepository provideSessionRepository(@NotNull ConferenceDataRepository conferenceDataRepository) {
        Intrinsics.checkParameterIsNotNull((Object)conferenceDataRepository, (String)"conferenceDataRepository");
        return new DefaultSessionRepository(conferenceDataRepository);
    }

    @Singleton
    @Provides
    @NotNull
    public final UserEventDataSource provideUserEventDataSource(@NotNull FirebaseFirestore firestore, @IoDispatcher @NotNull CoroutineDispatcher ioDispatcher) {
        Intrinsics.checkParameterIsNotNull((Object)firestore, (String)"firestore");
        Intrinsics.checkParameterIsNotNull((Object)ioDispatcher, (String)"ioDispatcher");
        return new FirestoreUserEventDataSource(firestore, ioDispatcher);
    }

    @Singleton
    @Provides
    @NotNull
    public final FeedbackEndpoint provideFeedbackEndpoint(@NotNull FirebaseFunctions functions) {
        Intrinsics.checkParameterIsNotNull((Object)functions, (String)"functions");
        return new DefaultFeedbackEndpoint(functions);
    }

    @Singleton
    @Provides
    @NotNull
    public final SessionAndUserEventRepository provideSessionAndUserEventRepository(@NotNull UserEventDataSource userEventDataSource, @NotNull SessionRepository sessionRepository) {
        Intrinsics.checkParameterIsNotNull((Object)userEventDataSource, (String)"userEventDataSource");
        Intrinsics.checkParameterIsNotNull((Object)sessionRepository, (String)"sessionRepository");
        return new DefaultSessionAndUserEventRepository(userEventDataSource, sessionRepository);
    }

    @Singleton
    @Provides
    @NotNull
    public final FirebaseFirestore provideFirebaseFireStore() {
        FirebaseFirestore firebaseFirestore = FirestoreKt.getFirestore((Firebase)Firebase.INSTANCE);
        boolean bl = false;
        boolean bl2 = false;
        FirebaseFirestore $this$apply = firebaseFirestore;
        boolean bl3 = false;
        $this$apply.setFirestoreSettings(FirestoreKt.firestoreSettings((Function1)provideFirebaseFireStore.1.1.INSTANCE));
        return firebaseFirestore;
    }

    @Singleton
    @Provides
    @NotNull
    public final FirebaseFunctions provideFirebaseFunctions() {
        return FunctionsKt.getFunctions((Firebase)Firebase.INSTANCE);
    }

    @Singleton
    @Provides
    @NotNull
    public final ArDebugFlagEndpoint provideArDebugFlagEndpoint(@NotNull FirebaseFunctions functions) {
        Intrinsics.checkParameterIsNotNull((Object)functions, (String)"functions");
        return new DefaultArDebugFlagEndpoint(functions);
    }

    @Singleton
    @Provides
    @NotNull
    public final TopicSubscriber provideTopicSubscriber() {
        return new FcmTopicSubscriber();
    }

    @Singleton
    @Provides
    @NotNull
    public final FirebaseRemoteConfigSettings provideFirebaseRemoteConfigSettings() {
        return RemoteConfigKt.remoteConfigSettings((Function1)provideFirebaseRemoteConfigSettings.2.INSTANCE);
    }

    @Singleton
    @Provides
    @NotNull
    public final FirebaseRemoteConfig provideFirebaseRemoteConfig(@NotNull FirebaseRemoteConfigSettings configSettings) {
        Intrinsics.checkParameterIsNotNull((Object)configSettings, (String)"configSettings");
        FirebaseRemoteConfig firebaseRemoteConfig = RemoteConfigKt.getRemoteConfig((Firebase)Firebase.INSTANCE);
        boolean bl = false;
        boolean bl2 = false;
        FirebaseRemoteConfig $this$apply = firebaseRemoteConfig;
        boolean bl3 = false;
        $this$apply.setConfigSettingsAsync(configSettings);
        $this$apply.setDefaultsAsync(R.xml.remote_config_defaults);
        return firebaseRemoteConfig;
    }

    @Singleton
    @Provides
    @NotNull
    public final AppConfigDataSource provideAppConfigDataSource(@NotNull FirebaseRemoteConfig remoteConfig, @NotNull FirebaseRemoteConfigSettings configSettings, @IoDispatcher @NotNull CoroutineDispatcher ioDispatcher) {
        Intrinsics.checkParameterIsNotNull((Object)remoteConfig, (String)"remoteConfig");
        Intrinsics.checkParameterIsNotNull((Object)configSettings, (String)"configSettings");
        Intrinsics.checkParameterIsNotNull((Object)ioDispatcher, (String)"ioDispatcher");
        return new RemoteAppConfigDataSource(remoteConfig, configSettings, ioDispatcher);
    }

    @Singleton
    @Provides
    @NotNull
    public final TimeProvider provideTimeProvider() {
        return DefaultTimeProvider.INSTANCE;
    }

    @Singleton
    @Provides
    @NotNull
    public final SessionTextMatchStrategy provideSessionTextMatchStrategy(@SearchUsingRoomEnabledFlag boolean useRoom, @NotNull AppDatabase appDatabase) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)appDatabase), (String)"appDatabase");
        return useRoom ? (SessionTextMatchStrategy)new FtsMatchStrategy(appDatabase) : (SessionTextMatchStrategy)SimpleMatchStrategy.INSTANCE;
    }
}

