/*
 * Decompiled with CFR 0.152.
 */
package com.google.samples.apps.iosched.shared.fcm;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.google.samples.apps.iosched.shared.data.job.ConferenceDataService;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0004H\u0002\u00a8\u0006\f"}, d2={"Lcom/google/samples/apps/iosched/shared/fcm/IoschedFirebaseMessagingService;", "Lcom/google/firebase/messaging/FirebaseMessagingService;", "()V", "onMessageReceived", "", "remoteMessage", "Lcom/google/firebase/messaging/RemoteMessage;", "onNewToken", "token", "", "scheduleFetchEventData", "Companion", "shared_release"})
public final class IoschedFirebaseMessagingService
extends FirebaseMessagingService {
    private static final String TRIGGER_EVENT_DATA_SYNC = "SYNC_EVENT_DATA";
    private static final String TRIGGER_EVENT_DATA_SYNC_key = "action";
    private static final long MINIMUM_LATENCY;
    private static final long OVERRIDE_DEADLINE;
    public static final Companion Companion;

    public void onNewToken(@NotNull String token) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        super.onNewToken(token);
        Timber.d((String)("New firebase token: " + token), (Object[])new Object[0]);
    }

    public void onMessageReceived(@NotNull RemoteMessage remoteMessage) {
        Intrinsics.checkParameterIsNotNull((Object)remoteMessage, (String)"remoteMessage");
        Timber.d((String)("Message data payload: " + remoteMessage.getData()), (Object[])new Object[0]);
        Map map2 = remoteMessage.getData();
        Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"remoteMessage.data");
        Map data = map2;
        if (Intrinsics.areEqual((Object)((String)data.get(TRIGGER_EVENT_DATA_SYNC_key)), (Object)TRIGGER_EVENT_DATA_SYNC)) {
            this.scheduleFetchEventData();
        }
    }

    private final void scheduleFetchEventData() {
        ComponentName serviceComponent = new ComponentName((Context)this, ConferenceDataService.class);
        JobInfo.Builder builder = new JobInfo.Builder(0xFE0FE0, serviceComponent).setMinimumLatency(MINIMUM_LATENCY).setRequiredNetworkType(2).setOverrideDeadline(OVERRIDE_DEADLINE);
        Object object = this.getSystemService("jobscheduler");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.app.job.JobScheduler");
        }
        JobScheduler jobScheduler = (JobScheduler)object;
        int result = jobScheduler.schedule(builder.build());
        if (result == 0) {
            Timber.e((String)"Invalid param supplied to JobScheduler when starting ConferenceDataService job.", (Object[])new Object[0]);
        } else if (result == 1) {
            Timber.i((String)"ConferenceDataService job scheduled..", (Object[])new Object[0]);
        }
    }

    static {
        Companion = new Companion(null);
        MINIMUM_LATENCY = TimeUnit.SECONDS.toMillis(5L);
        OVERRIDE_DEADLINE = TimeUnit.MINUTES.toMillis(15L);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/google/samples/apps/iosched/shared/fcm/IoschedFirebaseMessagingService$Companion;", "", "()V", "MINIMUM_LATENCY", "", "OVERRIDE_DEADLINE", "TRIGGER_EVENT_DATA_SYNC", "", "TRIGGER_EVENT_DATA_SYNC_key", "shared_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

