/*
 * Decompiled with CFR 0.152.
 */
package com.google.samples.apps.iosched.model;

import com.google.samples.apps.iosched.model.Room;
import com.google.samples.apps.iosched.model.Session;
import com.google.samples.apps.iosched.model.SessionType;
import com.google.samples.apps.iosched.model.Speaker;
import com.google.samples.apps.iosched.model.Tag;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.chrono.ChronoZonedDateTime;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u001f\b\u0086\b\u0018\u00002\u00020\u0001B\u009f\u0001\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0006\u0010\u0018\u001a\u00020\u0003\u0012\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u0016\u00a2\u0006\u0002\u0010\u001aJ\r\u0010E\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\t\u0010F\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u00c6\u0003J\u000f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u00c6\u0003J\u000f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u00c6\u0003J\t\u0010J\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010K\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u0016H\u00c6\u0003J\t\u0010L\u001a\u00020\u0006H\u00c6\u0003J\t\u0010M\u001a\u00020\u0006H\u00c6\u0003J\t\u0010N\u001a\u00020\u0003H\u00c6\u0003J\t\u0010O\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010P\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010Q\u001a\u00020\u0003H\u00c6\u0003J\t\u0010R\u001a\u00020\u000eH\u00c6\u0003J\t\u0010S\u001a\u00020\u0003H\u00c6\u0003J\u00c1\u0001\u0010T\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00032\b\b\u0002\u0010\u0010\u001a\u00020\u00032\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\b\u0002\u0010\u0018\u001a\u00020\u00032\u0012\b\u0002\u0010\u0019\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u0016H\u00c6\u0001J\u0013\u0010U\u001a\u00020\u000e2\b\u0010V\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0016\u0010W\u001a\u00020\u00032\u0006\u0010X\u001a\u00020\u00032\u0006\u0010Y\u001a\u00020\u0003J\t\u0010Z\u001a\u00020AH\u00d6\u0001J\u0006\u0010[\u001a\u00020\u000eJ\u000e\u0010\\\u001a\u00020\u000e2\u0006\u0010]\u001a\u00020\u0000J\b\u0010^\u001a\u0004\u0018\u00010\u0013J\t\u0010_\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001cR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0012\u0010&\u001a\u00020\u000e8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0012\u0010)\u001a\u00020\u000e8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b*\u0010(R\u0012\u0010+\u001a\u00020\u000e8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b,\u0010(R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u001cR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010(R\u001b\u0010.\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b.\u0010(R\u0011\u0010\u0018\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u001cR\u001b\u0010\u0019\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u001cR\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00103R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010%R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u001eR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\u001cR\u001b\u0010;\u001a\u00020<8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b?\u00100\u001a\u0004\b=\u0010>R\u0011\u0010@\u001a\u00020A\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010\u001c\u00a8\u0006`"}, d2={"Lcom/google/samples/apps/iosched/model/Session;", "", "id", "", "Lcom/google/samples/apps/iosched/model/SessionId;", "startTime", "Lorg/threeten/bp/ZonedDateTime;", "endTime", "title", "description", "room", "Lcom/google/samples/apps/iosched/model/Room;", "sessionUrl", "isLivestream", "", "youTubeUrl", "doryLink", "tags", "", "Lcom/google/samples/apps/iosched/model/Tag;", "displayTags", "speakers", "", "Lcom/google/samples/apps/iosched/model/Speaker;", "photoUrl", "relatedSessions", "(Ljava/lang/String;Lorg/threeten/bp/ZonedDateTime;Lorg/threeten/bp/ZonedDateTime;Ljava/lang/String;Ljava/lang/String;Lcom/google/samples/apps/iosched/model/Room;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/Set;Ljava/lang/String;Ljava/util/Set;)V", "getDescription", "()Ljava/lang/String;", "getDisplayTags", "()Ljava/util/List;", "getDoryLink", "duration", "", "getDuration", "()J", "getEndTime", "()Lorg/threeten/bp/ZonedDateTime;", "hasPhoto", "getHasPhoto", "()Z", "hasPhotoOrVideo", "getHasPhotoOrVideo", "hasVideo", "getHasVideo", "getId", "isReservable", "isReservable$delegate", "Lkotlin/Lazy;", "getPhotoUrl", "getRelatedSessions", "()Ljava/util/Set;", "getRoom", "()Lcom/google/samples/apps/iosched/model/Room;", "getSessionUrl", "getSpeakers", "getStartTime", "getTags", "getTitle", "type", "Lcom/google/samples/apps/iosched/model/SessionType;", "getType", "()Lcom/google/samples/apps/iosched/model/SessionType;", "type$delegate", "year", "", "getYear", "()I", "getYouTubeUrl", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "getCalendarDescription", "paragraphDelimiter", "speakerDelimiter", "hashCode", "isLive", "isOverlapping", "session", "levelTag", "toString", "model"})
public final class Session {
    private final int year;
    private final long duration;
    @NotNull
    private final Lazy type$delegate;
    @NotNull
    private final Lazy isReservable$delegate;
    @NotNull
    private final String id;
    @NotNull
    private final ZonedDateTime startTime;
    @NotNull
    private final ZonedDateTime endTime;
    @NotNull
    private final String title;
    @NotNull
    private final String description;
    @Nullable
    private final Room room;
    @NotNull
    private final String sessionUrl;
    private final boolean isLivestream;
    @NotNull
    private final String youTubeUrl;
    @NotNull
    private final String doryLink;
    @NotNull
    private final List<Tag> tags;
    @NotNull
    private final List<Tag> displayTags;
    @NotNull
    private final Set<Speaker> speakers;
    @NotNull
    private final String photoUrl;
    @NotNull
    private final Set<String> relatedSessions;

    public final boolean isLive() {
        ZonedDateTime now = ZonedDateTime.now();
        return this.startTime.compareTo((ChronoZonedDateTime)now) <= 0 && this.endTime.compareTo((ChronoZonedDateTime)now) >= 0;
    }

    public final boolean getHasPhoto() {
        int $i$f$getHasPhoto = 0;
        CharSequence charSequence = this.getPhotoUrl();
        boolean bl = false;
        return charSequence.length() > 0;
    }

    public final boolean getHasVideo() {
        int $i$f$getHasVideo = 0;
        CharSequence charSequence = this.getYouTubeUrl();
        boolean bl = false;
        return charSequence.length() > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getHasPhotoOrVideo() {
        int $i$f$getHasPhotoOrVideo = 0;
        Session this_$iv = this;
        boolean $i$f$getHasPhoto = false;
        CharSequence charSequence = this_$iv.getPhotoUrl();
        boolean bl = false;
        if (charSequence.length() > 0) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        this_$iv = this;
        boolean $i$f$getHasVideo = false;
        charSequence = this_$iv.getYouTubeUrl();
        bl = false;
        if (charSequence.length() <= 0) return false;
        return true;
    }

    public final int getYear() {
        return this.year;
    }

    public final long getDuration() {
        return this.duration;
    }

    @NotNull
    public final SessionType getType() {
        Lazy lazy = this.type$delegate;
        Session session = this;
        Object var3_3 = null;
        boolean bl = false;
        return (SessionType)((Object)lazy.getValue());
    }

    @Nullable
    public final Tag levelTag() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.tags;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Tag it = (Tag)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getCategory(), (Object)"level")) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final boolean isReservable() {
        Lazy lazy = this.isReservable$delegate;
        Session session = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    public final boolean isOverlapping(@NotNull Session session) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return this.startTime.compareTo((ChronoZonedDateTime)session.endTime) < 0 && this.endTime.compareTo((ChronoZonedDateTime)session.startTime) > 0;
    }

    @NotNull
    public final String getCalendarDescription(@NotNull String paragraphDelimiter, @NotNull String speakerDelimiter) {
        Intrinsics.checkParameterIsNotNull((Object)paragraphDelimiter, (String)"paragraphDelimiter");
        Intrinsics.checkParameterIsNotNull((Object)speakerDelimiter, (String)"speakerDelimiter");
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        $this$buildString.append(this.description);
        $this$buildString.append(paragraphDelimiter);
        $this$buildString.append(CollectionsKt.joinToString$default((Iterable)this.speakers, (CharSequence)speakerDelimiter, null, null, (int)0, null, (Function1)getCalendarDescription.1.1.INSTANCE, (int)30, null));
        if (!this.isLivestream) {
            CharSequence charSequence = this.youTubeUrl;
            boolean bl5 = false;
            if (!(charSequence.length() == 0)) {
                $this$buildString.append(paragraphDelimiter);
                $this$buildString.append(this.youTubeUrl);
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final ZonedDateTime getStartTime() {
        return this.startTime;
    }

    @NotNull
    public final ZonedDateTime getEndTime() {
        return this.endTime;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @Nullable
    public final Room getRoom() {
        return this.room;
    }

    @NotNull
    public final String getSessionUrl() {
        return this.sessionUrl;
    }

    public final boolean isLivestream() {
        return this.isLivestream;
    }

    @NotNull
    public final String getYouTubeUrl() {
        return this.youTubeUrl;
    }

    @NotNull
    public final String getDoryLink() {
        return this.doryLink;
    }

    @NotNull
    public final List<Tag> getTags() {
        return this.tags;
    }

    @NotNull
    public final List<Tag> getDisplayTags() {
        return this.displayTags;
    }

    @NotNull
    public final Set<Speaker> getSpeakers() {
        return this.speakers;
    }

    @NotNull
    public final String getPhotoUrl() {
        return this.photoUrl;
    }

    @NotNull
    public final Set<String> getRelatedSessions() {
        return this.relatedSessions;
    }

    public Session(@NotNull String id, @NotNull ZonedDateTime startTime, @NotNull ZonedDateTime endTime, @NotNull String title, @NotNull String description, @Nullable Room room, @NotNull String sessionUrl, boolean isLivestream, @NotNull String youTubeUrl, @NotNull String doryLink, @NotNull List<Tag> tags, @NotNull List<Tag> displayTags, @NotNull Set<Speaker> speakers, @NotNull String photoUrl, @NotNull Set<String> relatedSessions) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)startTime, (String)"startTime");
        Intrinsics.checkParameterIsNotNull((Object)endTime, (String)"endTime");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull((Object)sessionUrl, (String)"sessionUrl");
        Intrinsics.checkParameterIsNotNull((Object)youTubeUrl, (String)"youTubeUrl");
        Intrinsics.checkParameterIsNotNull((Object)doryLink, (String)"doryLink");
        Intrinsics.checkParameterIsNotNull(tags, (String)"tags");
        Intrinsics.checkParameterIsNotNull(displayTags, (String)"displayTags");
        Intrinsics.checkParameterIsNotNull(speakers, (String)"speakers");
        Intrinsics.checkParameterIsNotNull((Object)photoUrl, (String)"photoUrl");
        Intrinsics.checkParameterIsNotNull(relatedSessions, (String)"relatedSessions");
        this.id = id;
        this.startTime = startTime;
        this.endTime = endTime;
        this.title = title;
        this.description = description;
        this.room = room;
        this.sessionUrl = sessionUrl;
        this.isLivestream = isLivestream;
        this.youTubeUrl = youTubeUrl;
        this.doryLink = doryLink;
        this.tags = tags;
        this.displayTags = displayTags;
        this.speakers = speakers;
        this.photoUrl = photoUrl;
        this.relatedSessions = relatedSessions;
        this.year = this.startTime.getYear();
        this.duration = this.endTime.toInstant().toEpochMilli() - this.startTime.toInstant().toEpochMilli();
        this.type$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<SessionType>(this){
            final /* synthetic */ Session this$0;

            @NotNull
            public final SessionType invoke() {
                return SessionType.Companion.fromTags(this.this$0.getTags());
            }
            {
                this.this$0 = session;
                super(0);
            }
        }));
        this.isReservable$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ Session this$0;

            public final boolean invoke() {
                return SessionType.Companion.getReservableTypes$model().contains((Object)((Object)this.this$0.getType()));
            }
            {
                this.this$0 = session;
                super(0);
            }
        }));
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final ZonedDateTime component2() {
        return this.startTime;
    }

    @NotNull
    public final ZonedDateTime component3() {
        return this.endTime;
    }

    @NotNull
    public final String component4() {
        return this.title;
    }

    @NotNull
    public final String component5() {
        return this.description;
    }

    @Nullable
    public final Room component6() {
        return this.room;
    }

    @NotNull
    public final String component7() {
        return this.sessionUrl;
    }

    public final boolean component8() {
        return this.isLivestream;
    }

    @NotNull
    public final String component9() {
        return this.youTubeUrl;
    }

    @NotNull
    public final String component10() {
        return this.doryLink;
    }

    @NotNull
    public final List<Tag> component11() {
        return this.tags;
    }

    @NotNull
    public final List<Tag> component12() {
        return this.displayTags;
    }

    @NotNull
    public final Set<Speaker> component13() {
        return this.speakers;
    }

    @NotNull
    public final String component14() {
        return this.photoUrl;
    }

    @NotNull
    public final Set<String> component15() {
        return this.relatedSessions;
    }

    @NotNull
    public final Session copy(@NotNull String id, @NotNull ZonedDateTime startTime, @NotNull ZonedDateTime endTime, @NotNull String title, @NotNull String description, @Nullable Room room, @NotNull String sessionUrl, boolean isLivestream, @NotNull String youTubeUrl, @NotNull String doryLink, @NotNull List<Tag> tags, @NotNull List<Tag> displayTags, @NotNull Set<Speaker> speakers, @NotNull String photoUrl, @NotNull Set<String> relatedSessions) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)startTime, (String)"startTime");
        Intrinsics.checkParameterIsNotNull((Object)endTime, (String)"endTime");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull((Object)sessionUrl, (String)"sessionUrl");
        Intrinsics.checkParameterIsNotNull((Object)youTubeUrl, (String)"youTubeUrl");
        Intrinsics.checkParameterIsNotNull((Object)doryLink, (String)"doryLink");
        Intrinsics.checkParameterIsNotNull(tags, (String)"tags");
        Intrinsics.checkParameterIsNotNull(displayTags, (String)"displayTags");
        Intrinsics.checkParameterIsNotNull(speakers, (String)"speakers");
        Intrinsics.checkParameterIsNotNull((Object)photoUrl, (String)"photoUrl");
        Intrinsics.checkParameterIsNotNull(relatedSessions, (String)"relatedSessions");
        return new Session(id, startTime, endTime, title, description, room, sessionUrl, isLivestream, youTubeUrl, doryLink, tags, displayTags, speakers, photoUrl, relatedSessions);
    }

    public static /* synthetic */ Session copy$default(Session session, String string, ZonedDateTime zonedDateTime, ZonedDateTime zonedDateTime2, String string2, String string3, Room room, String string4, boolean bl, String string5, String string6, List list, List list2, Set set, String string7, Set set2, int n, Object object) {
        if ((n & 1) != 0) {
            string = session.id;
        }
        if ((n & 2) != 0) {
            zonedDateTime = session.startTime;
        }
        if ((n & 4) != 0) {
            zonedDateTime2 = session.endTime;
        }
        if ((n & 8) != 0) {
            string2 = session.title;
        }
        if ((n & 0x10) != 0) {
            string3 = session.description;
        }
        if ((n & 0x20) != 0) {
            room = session.room;
        }
        if ((n & 0x40) != 0) {
            string4 = session.sessionUrl;
        }
        if ((n & 0x80) != 0) {
            bl = session.isLivestream;
        }
        if ((n & 0x100) != 0) {
            string5 = session.youTubeUrl;
        }
        if ((n & 0x200) != 0) {
            string6 = session.doryLink;
        }
        if ((n & 0x400) != 0) {
            list = session.tags;
        }
        if ((n & 0x800) != 0) {
            list2 = session.displayTags;
        }
        if ((n & 0x1000) != 0) {
            set = session.speakers;
        }
        if ((n & 0x2000) != 0) {
            string7 = session.photoUrl;
        }
        if ((n & 0x4000) != 0) {
            set2 = session.relatedSessions;
        }
        return session.copy(string, zonedDateTime, zonedDateTime2, string2, string3, room, string4, bl, string5, string6, list, list2, set, string7, set2);
    }

    @NotNull
    public String toString() {
        return "Session(id=" + this.id + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", title=" + this.title + ", description=" + this.description + ", room=" + this.room + ", sessionUrl=" + this.sessionUrl + ", isLivestream=" + this.isLivestream + ", youTubeUrl=" + this.youTubeUrl + ", doryLink=" + this.doryLink + ", tags=" + this.tags + ", displayTags=" + this.displayTags + ", speakers=" + this.speakers + ", photoUrl=" + this.photoUrl + ", relatedSessions=" + this.relatedSessions + ")";
    }

    public int hashCode() {
        String string = this.id;
        ZonedDateTime zonedDateTime = this.startTime;
        ZonedDateTime zonedDateTime2 = this.endTime;
        String string2 = this.title;
        String string3 = this.description;
        Room room = this.room;
        String string4 = this.sessionUrl;
        int n = (((((((string != null ? string.hashCode() : 0) * 31 + (zonedDateTime != null ? zonedDateTime.hashCode() : 0)) * 31 + (zonedDateTime2 != null ? zonedDateTime2.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (room != null ? ((Object)room).hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31;
        int n2 = this.isLivestream ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        String string5 = this.youTubeUrl;
        String string6 = this.doryLink;
        List<Tag> list = this.tags;
        List<Tag> list2 = this.displayTags;
        Set<Speaker> set = this.speakers;
        String string7 = this.photoUrl;
        Set<String> set2 = this.relatedSessions;
        return (((((((n + n2) * 31 + (string5 != null ? string5.hashCode() : 0)) * 31 + (string6 != null ? string6.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (set != null ? ((Object)set).hashCode() : 0)) * 31 + (string7 != null ? string7.hashCode() : 0)) * 31 + (set2 != null ? ((Object)set2).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Session)) break block3;
                Session session = (Session)object;
                if (!Intrinsics.areEqual((Object)this.id, (Object)session.id) || !Intrinsics.areEqual((Object)this.startTime, (Object)session.startTime) || !Intrinsics.areEqual((Object)this.endTime, (Object)session.endTime) || !Intrinsics.areEqual((Object)this.title, (Object)session.title) || !Intrinsics.areEqual((Object)this.description, (Object)session.description) || !Intrinsics.areEqual((Object)this.room, (Object)session.room) || !Intrinsics.areEqual((Object)this.sessionUrl, (Object)session.sessionUrl) || this.isLivestream != session.isLivestream || !Intrinsics.areEqual((Object)this.youTubeUrl, (Object)session.youTubeUrl) || !Intrinsics.areEqual((Object)this.doryLink, (Object)session.doryLink) || !Intrinsics.areEqual(this.tags, session.tags) || !Intrinsics.areEqual(this.displayTags, session.displayTags) || !Intrinsics.areEqual(this.speakers, session.speakers) || !Intrinsics.areEqual((Object)this.photoUrl, (Object)session.photoUrl) || !Intrinsics.areEqual(this.relatedSessions, session.relatedSessions)) break block3;
            }
            return true;
        }
        return false;
    }
}

