/*
 * Decompiled with CFR 0.152.
 */
package com.google.samples.apps.iosched.shared.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.google.samples.apps.iosched.model.Codelab;
import com.google.samples.apps.iosched.model.ConferenceData;
import com.google.samples.apps.iosched.model.Room;
import com.google.samples.apps.iosched.model.Session;
import com.google.samples.apps.iosched.model.SessionType;
import com.google.samples.apps.iosched.model.Speaker;
import com.google.samples.apps.iosched.model.Tag;
import com.google.samples.apps.iosched.shared.data.TempConferenceData;
import com.google.samples.apps.iosched.shared.data.session.json.CodelabDeserializer;
import com.google.samples.apps.iosched.shared.data.session.json.CodelabTemp;
import com.google.samples.apps.iosched.shared.data.session.json.RoomDeserializer;
import com.google.samples.apps.iosched.shared.data.session.json.SessionDeserializer;
import com.google.samples.apps.iosched.shared.data.session.json.SessionTemp;
import com.google.samples.apps.iosched.shared.data.session.json.SpeakerDeserializer;
import com.google.samples.apps.iosched.shared.data.session.json.TagDeserializer;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.threeten.bp.ZonedDateTime;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/google/samples/apps/iosched/shared/data/ConferenceDataJsonParser;", "", "()V", "normalize", "Lcom/google/samples/apps/iosched/model/ConferenceData;", "data", "Lcom/google/samples/apps/iosched/shared/data/TempConferenceData;", "parseConferenceData", "unprocessedSessionData", "Ljava/io/InputStream;", "shared_release"})
public final class ConferenceDataJsonParser {
    public static final ConferenceDataJsonParser INSTANCE;

    @NotNull
    public final ConferenceData parseConferenceData(@NotNull InputStream unprocessedSessionData) throws JsonIOException, JsonSyntaxException {
        Intrinsics.checkParameterIsNotNull((Object)unprocessedSessionData, (String)"unprocessedSessionData");
        InputStream inputStream = unprocessedSessionData;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
        Reader reader = inputStreamReader;
        JsonReader jsonReader = new JsonReader(reader);
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)SessionTemp.class), (Object)new SessionDeserializer()).registerTypeAdapter((Type)((Object)Tag.class), (Object)new TagDeserializer()).registerTypeAdapter((Type)((Object)Speaker.class), (Object)new SpeakerDeserializer()).registerTypeAdapter((Type)((Object)Room.class), (Object)new RoomDeserializer()).registerTypeAdapter((Type)((Object)CodelabTemp.class), (Object)new CodelabDeserializer()).create();
        Object object = gson.fromJson(jsonReader, (Type)((Object)TempConferenceData.class));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gson.fromJson(jsonReader\u2026nferenceData::class.java)");
        TempConferenceData tempData = (TempConferenceData)object;
        return this.normalize(tempData);
    }

    /*
     * WARNING - void declaration
     */
    private final ConferenceData normalize(TempConferenceData data) {
        Iterable $this$firstOrNull$iv;
        boolean bl = false;
        List sessions = new ArrayList();
        Iterable $this$forEach$iv = data.getSessions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v1;
            String string2;
            Set<String> set;
            Collection collection;
            Object object;
            String $this$mapNotNullTo$iv$iv;
            String string3;
            ZonedDateTime zonedDateTime;
            ZonedDateTime zonedDateTime2;
            String string4;
            String string5;
            String string6;
            boolean bl2;
            String string7;
            String string8;
            List list;
            List list2;
            Object it;
            block9: {
                Iterable $this$mapNotNull$iv;
                List list3;
                Collection destination$iv$iv;
                void $this$filterTo$iv$iv;
                SessionTemp session2 = (SessionTemp)element$iv;
                boolean bl3 = false;
                Iterable $this$filter$iv = data.getTags();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Tag)element$iv$iv;
                    boolean bl4 = false;
                    if (!session2.getTagNames().contains(it.getTagName())) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List tags = (List)destination$iv$iv2;
                SessionType type = SessionType.Companion.fromTags(tags);
                if (type == SessionType.SESSION || type == SessionType.KEYNOTE) {
                    void $this$filterTo$iv$iv2;
                    Iterable $this$filter$iv2 = tags;
                    boolean $i$f$filter2 = false;
                    Iterable $i$f$filterTo2 = $this$filter$iv2;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo3 = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                        Tag it2 = (Tag)element$iv$iv;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)it2.getCategory(), (Object)"topic")) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list3 = (List)destination$iv$iv;
                } else {
                    list3 = CollectionsKt.emptyList();
                }
                List displayTags = list3;
                Iterable $i$f$filter2 = session2.getSpeakers();
                list2 = displayTags;
                list = tags;
                string8 = session2.getDoryLink();
                string7 = session2.getYouTubeUrl();
                bl2 = session2.isLivestream();
                string6 = session2.getSessionUrl();
                string5 = session2.getDescription();
                string4 = session2.getTitle();
                zonedDateTime2 = session2.getEndTime();
                zonedDateTime = session2.getStartTime();
                string3 = session2.getId();
                boolean $i$f$mapNotNull = false;
                destination$iv$iv = $this$mapNotNull$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach2 = false;
                object = $this$forEach$iv$iv$iv.iterator();
                while (object.hasNext()) {
                    Speaker speaker;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = object.next();
                    boolean bl6 = false;
                    String it3 = (String)element$iv$iv;
                    boolean bl7 = false;
                    if (data.getSpeakers().get(it3) == null) continue;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    Speaker it$iv$iv = speaker;
                    boolean bl10 = false;
                    destination$iv$iv3.add(it$iv$iv);
                }
                collection = (List)destination$iv$iv3;
                $this$mapNotNull$iv = data.getRooms();
                set = session2.getRelatedSessions();
                string2 = session2.getPhotoUrl();
                collection = CollectionsKt.toSet((Iterable)collection);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    Room it4 = (Room)element$iv2;
                    boolean bl11 = false;
                    if (!Intrinsics.areEqual((Object)it4.getId(), (Object)session2.getRoom())) continue;
                    v1 = element$iv2;
                    break block9;
                }
                v1 = null;
            }
            Object var47_74 = v1;
            $this$firstOrNull$iv = var47_74;
            Set<String> $i$f$firstOrNull = set;
            $this$mapNotNullTo$iv$iv = string2;
            List list4 = collection;
            it = list2;
            List bl11 = list;
            String $i$f$forEach2 = string8;
            object = string7;
            boolean bl12 = bl2;
            String string9 = string6;
            Set<String> set2 = $i$f$firstOrNull;
            String string10 = $this$mapNotNullTo$iv$iv;
            Object object2 = list4;
            Object object3 = it;
            List list5 = bl11;
            String string11 = $i$f$forEach2;
            Object object4 = object;
            boolean bl13 = bl12;
            String string12 = string9;
            Iterable iterable = $this$firstOrNull$iv;
            String string13 = string5;
            String string14 = string4;
            ZonedDateTime zonedDateTime3 = zonedDateTime2;
            ZonedDateTime zonedDateTime4 = zonedDateTime;
            String string15 = string3;
            Session newSession = new Session(string15, zonedDateTime4, zonedDateTime3, string14, string13, (Room)iterable, string12, bl13, (String)object4, string11, list5, (List)object3, (Set)object2, string10, set2);
            sessions.add(newSession);
        }
        $i$f$forEach = false;
        List codelabs = new ArrayList();
        Iterable $this$forEach$iv2 = data.getCodelabs();
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv2) {
            void $this$filterTo$iv$iv;
            CodelabTemp codelab = (CodelabTemp)element$iv;
            boolean bl14 = false;
            Iterable $this$filter$iv = data.getTags();
            boolean $i$f$filter = false;
            $this$firstOrNull$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Tag it = (Tag)element$iv$iv;
                boolean bl15 = false;
                if (!(Intrinsics.areEqual((Object)it.getCategory(), (Object)"topic") && codelab.getTagNames().contains(it.getTagName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List tags = (List)destination$iv$iv;
            Codelab newCodelab = new Codelab(codelab.getId(), codelab.getTitle(), codelab.getDescription(), codelab.getDurationMinutes(), codelab.getIconUrl(), codelab.getCodelabUrl(), codelab.getSortPriority(), tags);
            codelabs.add(newCodelab);
        }
        return new ConferenceData(sessions, CollectionsKt.toList((Iterable)data.getSpeakers().values()), data.getRooms(), codelabs, data.getTags(), data.getVersion());
    }

    private ConferenceDataJsonParser() {
    }

    static {
        ConferenceDataJsonParser conferenceDataJsonParser;
        INSTANCE = conferenceDataJsonParser = new ConferenceDataJsonParser();
    }
}

