/*
 * Decompiled with CFR 0.152.
 */
package com.google.samples.apps.iosched.shared.domain.sessions;

import com.google.gson.Gson;
import com.google.samples.apps.iosched.model.Session;
import com.google.samples.apps.iosched.model.schedule.PinnedSession;
import com.google.samples.apps.iosched.model.schedule.PinnedSessionsSchedule;
import com.google.samples.apps.iosched.model.userdata.UserSession;
import com.google.samples.apps.iosched.shared.data.userevent.DefaultSessionAndUserEventRepository;
import com.google.samples.apps.iosched.shared.data.userevent.ObservableUserEvents;
import com.google.samples.apps.iosched.shared.di.IoDispatcher;
import com.google.samples.apps.iosched.shared.domain.FlowUseCase;
import com.google.samples.apps.iosched.shared.domain.sessions.LoadPinnedSessionsJsonUseCase$execute$;
import com.google.samples.apps.iosched.shared.result.Result;
import com.google.samples.apps.iosched.shared.util.ExtensionsKt;
import com.google.samples.apps.iosched.shared.util.TimeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.threeten.bp.ZonedDateTime;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B!\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/google/samples/apps/iosched/shared/domain/sessions/LoadPinnedSessionsJsonUseCase;", "Lcom/google/samples/apps/iosched/shared/domain/FlowUseCase;", "", "userEventRepository", "Lcom/google/samples/apps/iosched/shared/data/userevent/DefaultSessionAndUserEventRepository;", "gson", "Lcom/google/gson/Gson;", "ioDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lcom/google/samples/apps/iosched/shared/data/userevent/DefaultSessionAndUserEventRepository;Lcom/google/gson/Gson;Lkotlinx/coroutines/CoroutineDispatcher;)V", "execute", "Lkotlinx/coroutines/flow/Flow;", "Lcom/google/samples/apps/iosched/shared/result/Result;", "parameters", "shared_release"})
public class LoadPinnedSessionsJsonUseCase
extends FlowUseCase<String, String> {
    private final DefaultSessionAndUserEventRepository userEventRepository;
    private final Gson gson;
    private final CoroutineDispatcher ioDispatcher;

    @Override
    @NotNull
    protected Flow<Result<String>> execute(@NotNull String parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Flow<Result<ObservableUserEvents>> $this$map$iv = this.userEventRepository.getObservableUserEvents(parameters);
        boolean $i$f$map = false;
        Flow<Result<ObservableUserEvents>> $this$unsafeTransform$iv$iv = $this$map$iv;
        boolean $i$f$unsafeTransform = false;
        boolean $i$f$unsafeFlow = false;
        return (Flow)new Flow<Result<? extends String>>($this$unsafeTransform$iv$iv, this){
            final /* synthetic */ Flow $this_unsafeTransform$inlined;
            final /* synthetic */ LoadPinnedSessionsJsonUseCase this$0;
            {
                this.$this_unsafeTransform$inlined = flow;
                this.this$0 = loadPinnedSessionsJsonUseCase;
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public Object collect(@NotNull FlowCollector flowCollector, @NotNull Continuation $completion) {
                void $this$collect$iv;
                void collector;
                Continuation continuation = $completion;
                void $receiver = collector;
                boolean bl = false;
                Flow flow = this.$this_unsafeTransform$inlined;
                Continuation continuation2 = $completion;
                boolean $i$f$collect = false;
                Object object = $this$collect$iv.collect((FlowCollector)new FlowCollector<Result<? extends ObservableUserEvents>>((FlowCollector)$receiver, this){
                    final /* synthetic */ FlowCollector $this_unsafeFlow$inlined;
                    final /* synthetic */ execute$$inlined$map$1 this$0;
                    {
                        this.$this_unsafeFlow$inlined = flowCollector;
                        this.this$0 = var2_2;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Nullable
                    public Object emit(Object object, @NotNull Continuation $completion) {
                        Result result;
                        void observableResult;
                        void value;
                        void value2;
                        Continuation continuation = $completion;
                        void value3 = value2;
                        boolean bl = false;
                        Continuation continuation2 = $completion;
                        void var7_7 = value3;
                        FlowCollector $receiver = this.$this_unsafeFlow$inlined;
                        boolean bl2 = false;
                        Continuation continuation3 = $completion;
                        Result result2 = (Result)value;
                        FlowCollector flowCollector = $receiver;
                        boolean bl3 = false;
                        void var14_14 = observableResult;
                        if (var14_14 instanceof Result.Success) {
                            void $this$mapTo$iv$iv;
                            UserSession it;
                            Iterable $this$filterTo$iv$iv;
                            Iterable $this$filter$iv = ((ObservableUserEvents)((Result.Success)observableResult).getData()).getUserSessions();
                            boolean $i$f$filter = false;
                            Iterable iterable = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                it = (UserSession)element$iv$iv;
                                boolean bl4 = false;
                                if (!Boxing.boxBoolean((boolean)it.getUserEvent().isStarredOrReserved()).booleanValue()) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            Iterable $this$map$iv = (List)destination$iv$iv;
                            boolean $i$f$map = false;
                            $this$filterTo$iv$iv = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                it = (UserSession)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl5 = false;
                                Session session2 = it.getSession();
                                ZonedDateTime zonedTime = TimeUtils.INSTANCE.zonedTime(session2.getStartTime(), TimeUtils.INSTANCE.getCONFERENCE_TIMEZONE());
                                String string2 = session2.getTitle();
                                Object object2 = session2.getRoom();
                                if (object2 == null || (object2 = object2.getName()) == null) {
                                    object2 = "";
                                }
                                PinnedSession pinnedSession = new PinnedSession(string2, (String)object2, TimeUtils.INSTANCE.abbreviatedDayForAr(zonedTime), TimeUtils.INSTANCE.abbreviatedTimeForAr(zonedTime), ExtensionsKt.toEpochMilli(session2.getStartTime()), session2.getDescription());
                                collection.add(pinnedSession);
                            }
                            List useCaseResult = (List)destination$iv$iv;
                            String jsonResult = LoadPinnedSessionsJsonUseCase.access$getGson$p(this.this$0.this$0).toJson((Object)new PinnedSessionsSchedule(useCaseResult));
                            result = new Result.Success<String>(jsonResult);
                        } else if (var14_14 instanceof Result.Error) {
                            result = new Result.Error(((Result.Error)observableResult).getException());
                        } else if (var14_14 instanceof Result.Loading) {
                            result = observableResult;
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        void var29_29 = result;
                        Object object3 = flowCollector.emit((Object)var29_29, $completion);
                        if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                            return object3;
                        }
                        return Unit.INSTANCE;
                    }
                }, continuation2);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        };
    }

    @Inject
    public LoadPinnedSessionsJsonUseCase(@NotNull DefaultSessionAndUserEventRepository userEventRepository, @NotNull Gson gson, @IoDispatcher @NotNull CoroutineDispatcher ioDispatcher) {
        Intrinsics.checkParameterIsNotNull((Object)userEventRepository, (String)"userEventRepository");
        Intrinsics.checkParameterIsNotNull((Object)gson, (String)"gson");
        Intrinsics.checkParameterIsNotNull((Object)ioDispatcher, (String)"ioDispatcher");
        super(ioDispatcher);
        this.userEventRepository = userEventRepository;
        this.gson = gson;
        this.ioDispatcher = ioDispatcher;
    }

    public static final /* synthetic */ Gson access$getGson$p(LoadPinnedSessionsJsonUseCase $this) {
        return $this.gson;
    }
}

