package com.example.viewstub_viewbinding

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.util.Log
import android.view.LayoutInflater
import android.widget.TextView
import com.example.viewstub_viewbinding.databinding.ActivityMainBinding
import android.view.ViewStub
import androidx.databinding.ViewStubProxy

class MainActivity : AppCompatActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        val binding = ActivityMainBinding.inflate(LayoutInflater.from(this))
        setContentView(binding.root)

        Log.d("MainActivity", "binding.viewStub: ${binding.viewStub}")
        /**
         * The binding.viewStub actual type is [ViewStub],
         * but the IDE treat it as [ViewStubProxy]
         */
        val view = binding.viewStub.inflate()

        val textView = view.findViewById<TextView>(R.id.textInViewStub)
        textView.text = "This TextView is in ViewStub"
    }
}