package gmk57.testtransition

import android.os.Bundle
import android.view.View
import android.widget.Button
import androidx.fragment.app.Fragment
import androidx.fragment.app.commit
import com.google.android.material.transition.MaterialSharedAxis

class FirstFragment : Fragment(R.layout.fragment_first) {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setSlideTransitions()
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        view.findViewById<Button>(R.id.button).setOnClickListener {
            parentFragmentManager.commit {
                replace(R.id.fragmentContainer, SecondFragment()).addToBackStack(null)
            }
        }
    }
}

fun Fragment.setSlideTransitions() {
    enterTransition = MaterialSharedAxis(MaterialSharedAxis.X, true).apply { duration = 5000 }
    exitTransition = MaterialSharedAxis(MaterialSharedAxis.X, true).apply { duration = 5000 }
    reenterTransition = MaterialSharedAxis(MaterialSharedAxis.X, false).apply { duration = 5000 }
    returnTransition = MaterialSharedAxis(MaterialSharedAxis.X, false).apply { duration = 5000 }
}
