package com.sample.SampleProject;

import android.app.Application;

import androidx.room.Database;
import androidx.room.Room;
import androidx.room.RoomDatabase;

@Database(entities = {sample.class}, version = 1)
public abstract class db extends RoomDatabase {

    private static volatile db INSTANCE = null;

    public static db getInstance(Application context){
        if(INSTANCE == null){
            synchronized(db.class) {
                if(INSTANCE == null){
                    INSTANCE = Room.databaseBuilder(context, db.class, "Story_Helper").build();
                }
            }
        }
        return INSTANCE;
    }

    public abstract sampleDao getSampleDAO();

}
