package com.lb.myapplication

import android.content.Context
import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.provider.ContactsContract
import android.util.Log
import androidx.appcompat.app.AppCompatActivity

class MainActivity : AppCompatActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        Log.d("AppLog", "start")
        getOpenContactsAppIntent(this)
        Log.d("AppLog", "end")
    }

    companion object {
        fun getOpenContactsAppIntent(context: Context) {
            val packageManager = context.packageManager
            val intents = ArrayList<Intent>()
            intents.add(Intent(Intent.ACTION_MAIN).addCategory(Intent.CATEGORY_APP_CONTACTS))
            intents.add(Intent(Intent.ACTION_VIEW).setData(Uri.parse("content://contacts/people")))
            intents.add(Intent(Intent.ACTION_VIEW, ContactsContract.Contacts.CONTENT_URI))
            intents.forEachIndexed { index, intent ->
                val activities = packageManager.queryIntentActivities(intent, 0)
                val apps = HashSet<String>(activities.size)
                activities.forEach { apps.add(it.activityInfo.packageName) }
                Log.d("AppLog", "$index apps activities found for intent:${activities.size} apps:$apps")
            }
        }
    }
}
