/*
 * Decompiled with CFR 0.152.
 */
package com.android.samples.donuttracker.core.storage;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.lifecycle.LiveData;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.android.samples.donuttracker.core.model.Coffee;
import com.android.samples.donuttracker.core.storage.CoffeeDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class CoffeeDao_Impl
implements CoffeeDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Coffee> __insertionAdapterOfCoffee;
    private final EntityDeletionOrUpdateAdapter<Coffee> __deletionAdapterOfCoffee;
    private final EntityDeletionOrUpdateAdapter<Coffee> __updateAdapterOfCoffee;

    public CoffeeDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCoffee = new EntityInsertionAdapter<Coffee>(__db){

            public String createQuery() {
                return "INSERT OR ABORT INTO `Coffee` (`id`,`name`,`description`,`rating`) VALUES (nullif(?, 0),?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Coffee value) {
                stmt.bindLong(1, value.getId());
                if (value.getName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getName());
                }
                if (value.getDescription() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getDescription());
                }
                stmt.bindLong(4, (long)value.getRating());
            }
        };
        this.__deletionAdapterOfCoffee = new EntityDeletionOrUpdateAdapter<Coffee>(__db){

            public String createQuery() {
                return "DELETE FROM `Coffee` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Coffee value) {
                stmt.bindLong(1, value.getId());
            }
        };
        this.__updateAdapterOfCoffee = new EntityDeletionOrUpdateAdapter<Coffee>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `Coffee` SET `id` = ?,`name` = ?,`description` = ?,`rating` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Coffee value) {
                stmt.bindLong(1, value.getId());
                if (value.getName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getName());
                }
                if (value.getDescription() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getDescription());
                }
                stmt.bindLong(4, (long)value.getRating());
                stmt.bindLong(5, value.getId());
            }
        };
    }

    @Override
    public Object insert(final Coffee coffee, Continuation<? super Long> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long call() throws Exception {
                CoffeeDao_Impl.this.__db.beginTransaction();
                try {
                    long _result = CoffeeDao_Impl.this.__insertionAdapterOfCoffee.insertAndReturnId((Object)coffee);
                    CoffeeDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result;
                    return l;
                }
                finally {
                    CoffeeDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object delete(final Coffee coffee, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                CoffeeDao_Impl.this.__db.beginTransaction();
                try {
                    CoffeeDao_Impl.this.__deletionAdapterOfCoffee.handle((Object)coffee);
                    CoffeeDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    CoffeeDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object update(final Coffee coffee, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                CoffeeDao_Impl.this.__db.beginTransaction();
                try {
                    CoffeeDao_Impl.this.__updateAdapterOfCoffee.handle((Object)coffee);
                    CoffeeDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    CoffeeDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public LiveData<List<Coffee>> getAll() {
        String _sql = "SELECT * FROM coffee";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM coffee", (int)0);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"coffee"}, false, (Callable)new Callable<List<Coffee>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Coffee> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)CoffeeDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfRating = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rating");
                    ArrayList<Coffee> _result = new ArrayList<Coffee>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                        int _tmpRating = _cursor.getInt(_cursorIndexOfRating);
                        Coffee _item = new Coffee(_tmpId, _tmpName, _tmpDescription, _tmpRating);
                        _result.add(_item);
                    }
                    ArrayList<Coffee> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object get(long id2, Continuation<? super Coffee> p1) {
        String _sql = "SELECT * FROM coffee WHERE id = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM coffee WHERE id = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, id2);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Coffee>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Coffee call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)CoffeeDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Coffee _result;
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfRating = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rating");
                    if (_cursor.moveToFirst()) {
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                        int _tmpRating = _cursor.getInt(_cursorIndexOfRating);
                        _result = new Coffee(_tmpId, _tmpName, _tmpDescription, _tmpRating);
                    } else {
                        _result = null;
                    }
                    Coffee coffee = _result;
                    return coffee;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p1);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

