/*
 * Decompiled with CFR 0.152.
 */
package com.android.samples.donuttracker.core.storage;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.lifecycle.LiveData;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.android.samples.donuttracker.core.model.Donut;
import com.android.samples.donuttracker.core.storage.DonutDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class DonutDao_Impl
implements DonutDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Donut> __insertionAdapterOfDonut;
    private final EntityDeletionOrUpdateAdapter<Donut> __deletionAdapterOfDonut;
    private final EntityDeletionOrUpdateAdapter<Donut> __updateAdapterOfDonut;

    public DonutDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfDonut = new EntityInsertionAdapter<Donut>(__db){

            public String createQuery() {
                return "INSERT OR ABORT INTO `Donut` (`id`,`name`,`description`,`rating`) VALUES (nullif(?, 0),?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Donut value) {
                stmt.bindLong(1, value.getId());
                if (value.getName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getName());
                }
                if (value.getDescription() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getDescription());
                }
                stmt.bindLong(4, (long)value.getRating());
            }
        };
        this.__deletionAdapterOfDonut = new EntityDeletionOrUpdateAdapter<Donut>(__db){

            public String createQuery() {
                return "DELETE FROM `Donut` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Donut value) {
                stmt.bindLong(1, value.getId());
            }
        };
        this.__updateAdapterOfDonut = new EntityDeletionOrUpdateAdapter<Donut>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `Donut` SET `id` = ?,`name` = ?,`description` = ?,`rating` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Donut value) {
                stmt.bindLong(1, value.getId());
                if (value.getName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getName());
                }
                if (value.getDescription() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getDescription());
                }
                stmt.bindLong(4, (long)value.getRating());
                stmt.bindLong(5, value.getId());
            }
        };
    }

    @Override
    public Object insert(final Donut donut, Continuation<? super Long> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long call() throws Exception {
                DonutDao_Impl.this.__db.beginTransaction();
                try {
                    long _result = DonutDao_Impl.this.__insertionAdapterOfDonut.insertAndReturnId((Object)donut);
                    DonutDao_Impl.this.__db.setTransactionSuccessful();
                    Long l = _result;
                    return l;
                }
                finally {
                    DonutDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object delete(final Donut donut, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                DonutDao_Impl.this.__db.beginTransaction();
                try {
                    DonutDao_Impl.this.__deletionAdapterOfDonut.handle((Object)donut);
                    DonutDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    DonutDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public Object update(final Donut donut, Continuation<? super Unit> p1) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                DonutDao_Impl.this.__db.beginTransaction();
                try {
                    DonutDao_Impl.this.__updateAdapterOfDonut.handle((Object)donut);
                    DonutDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    DonutDao_Impl.this.__db.endTransaction();
                }
            }
        }, p1);
    }

    @Override
    public LiveData<List<Donut>> getAll() {
        String _sql = "SELECT * FROM donut";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM donut", (int)0);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"donut"}, false, (Callable)new Callable<List<Donut>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Donut> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)DonutDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfRating = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rating");
                    ArrayList<Donut> _result = new ArrayList<Donut>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                        int _tmpRating = _cursor.getInt(_cursorIndexOfRating);
                        Donut _item = new Donut(_tmpId, _tmpName, _tmpDescription, _tmpRating);
                        _result.add(_item);
                    }
                    ArrayList<Donut> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Object get(long id2, Continuation<? super Donut> p1) {
        String _sql = "SELECT * FROM donut WHERE id = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM donut WHERE id = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, id2);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Donut>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Donut call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)DonutDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Donut _result;
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfRating = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rating");
                    if (_cursor.moveToFirst()) {
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                        int _tmpRating = _cursor.getInt(_cursorIndexOfRating);
                        _result = new Donut(_tmpId, _tmpName, _tmpDescription, _tmpRating);
                    } else {
                        _result = null;
                    }
                    Donut donut = _result;
                    return donut;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, p1);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

