/*
 * Decompiled with CFR 0.152.
 */
package com.android.samples.donuttracker.donut;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.ListAdapter;
import androidx.recyclerview.widget.RecyclerView;
import com.android.samples.donuttracker.core.model.Donut;
import com.android.samples.donuttracker.databinding.DonutItemBinding;
import com.android.samples.donuttracker.donut.DonutDiffCallback;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0011B-\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/samples/donuttracker/donut/DonutListAdapter;", "Landroidx/recyclerview/widget/ListAdapter;", "Lcom/android/samples/donuttracker/core/model/Donut;", "Lcom/android/samples/donuttracker/donut/DonutListAdapter$DonutListViewHolder;", "onEdit", "Lkotlin/Function1;", "", "onDelete", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "onBindViewHolder", "holder", "position", "", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "DonutListViewHolder", "app_debug"})
public final class DonutListAdapter
extends ListAdapter<Donut, DonutListViewHolder> {
    @NotNull
    private Function1<? super Donut, Unit> onEdit;
    @NotNull
    private Function1<? super Donut, Unit> onDelete;

    public DonutListAdapter(@NotNull Function1<? super Donut, Unit> onEdit, @NotNull Function1<? super Donut, Unit> onDelete) {
        Intrinsics.checkNotNullParameter(onEdit, (String)"onEdit");
        Intrinsics.checkNotNullParameter(onDelete, (String)"onDelete");
        super((DiffUtil.ItemCallback)new DonutDiffCallback());
        this.onEdit = onEdit;
        this.onDelete = onDelete;
    }

    @NotNull
    public DonutListViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        DonutItemBinding donutItemBinding = DonutItemBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)donutItemBinding, (String)"inflate(LayoutInflater.from(parent.context), parent, false)");
        return new DonutListViewHolder(donutItemBinding, this.onEdit, this.onDelete);
    }

    public void onBindViewHolder(@NotNull DonutListViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        Object object = this.getItem(position);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(position)");
        holder.bind((Donut)object);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/samples/donuttracker/donut/DonutListAdapter$DonutListViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lcom/android/samples/donuttracker/databinding/DonutItemBinding;", "onEdit", "Lkotlin/Function1;", "Lcom/android/samples/donuttracker/core/model/Donut;", "", "onDelete", "(Lcom/android/samples/donuttracker/databinding/DonutItemBinding;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "description", "Landroid/widget/TextView;", "donut", "donutId", "", "nameView", "rating", "thumbnail", "Landroid/widget/ImageView;", "bind", "app_debug"})
    public static final class DonutListViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final DonutItemBinding binding;
        @NotNull
        private Function1<? super Donut, Unit> onEdit;
        @NotNull
        private Function1<? super Donut, Unit> onDelete;
        private long donutId;
        @NotNull
        private TextView nameView;
        @NotNull
        private TextView description;
        @NotNull
        private ImageView thumbnail;
        @NotNull
        private TextView rating;
        @Nullable
        private Donut donut;

        public DonutListViewHolder(@NotNull DonutItemBinding binding, @NotNull Function1<? super Donut, Unit> onEdit, @NotNull Function1<? super Donut, Unit> onDelete) {
            Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
            Intrinsics.checkNotNullParameter(onEdit, (String)"onEdit");
            Intrinsics.checkNotNullParameter(onDelete, (String)"onDelete");
            super((View)binding.getRoot());
            this.binding = binding;
            this.onEdit = onEdit;
            this.onDelete = onDelete;
            this.donutId = -1L;
            TextView textView = this.binding.name;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.name");
            this.nameView = textView;
            textView = this.binding.description;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.description");
            this.description = textView;
            textView = this.binding.thumbnail;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.thumbnail");
            this.thumbnail = textView;
            textView = this.binding.rating;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.rating");
            this.rating = textView;
        }

        public final void bind(@NotNull Donut donut) {
            Intrinsics.checkNotNullParameter((Object)donut, (String)"donut");
            this.donutId = donut.getId();
            this.nameView.setText((CharSequence)donut.getName());
            this.description.setText((CharSequence)donut.getDescription());
            this.rating.setText((CharSequence)String.valueOf(donut.getRating()));
            this.thumbnail.setImageResource(2131165294);
            this.donut = donut;
            this.binding.deleteButton.setOnClickListener(arg_0 -> DonutListViewHolder.bind$lambda-0(this, donut, arg_0));
            this.binding.getRoot().setOnClickListener(arg_0 -> DonutListViewHolder.bind$lambda-1(this, donut, arg_0));
        }

        private static final void bind$lambda-0(DonutListViewHolder this$0, Donut $donut, View it) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$donut, (String)"$donut");
            this$0.onDelete.invoke((Object)$donut);
        }

        private static final void bind$lambda-1(DonutListViewHolder this$0, Donut $donut, View it) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$donut, (String)"$donut");
            this$0.onEdit.invoke((Object)$donut);
        }
    }
}

