/*
 * Decompiled with CFR 0.152.
 */
package com.android.samples.donuttracker.core.storage;

import android.content.Context;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import com.android.samples.donuttracker.core.storage.CoffeeDao;
import com.android.samples.donuttracker.core.storage.CoffeeDao_Impl;
import com.android.samples.donuttracker.core.storage.DonutDao;
import com.android.samples.donuttracker.core.storage.DonutDao_Impl;
import com.android.samples.donuttracker.core.storage.SnackDatabase;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class SnackDatabase_Impl
extends SnackDatabase {
    private volatile DonutDao _donutDao;
    private volatile CoffeeDao _coffeeDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(1){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `Donut` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `name` TEXT NOT NULL, `description` TEXT NOT NULL, `rating` INTEGER NOT NULL)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `Coffee` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `name` TEXT NOT NULL, `description` TEXT NOT NULL, `rating` INTEGER NOT NULL)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '459a821437fd5c2f5df3f31248b9e792')");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `Donut`");
                _db.execSQL("DROP TABLE IF EXISTS `Coffee`");
                if (SnackDatabase_Impl.this.mCallbacks != null) {
                    int _size = SnackDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)SnackDatabase_Impl.this.mCallbacks.get(_i)).onDestructiveMigration(_db);
                    }
                }
            }

            protected void onCreate(SupportSQLiteDatabase _db) {
                if (SnackDatabase_Impl.this.mCallbacks != null) {
                    int _size = SnackDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)SnackDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                SnackDatabase_Impl.this.mDatabase = _db;
                SnackDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (SnackDatabase_Impl.this.mCallbacks != null) {
                    int _size = SnackDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)SnackDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            public void onPreMigrate(SupportSQLiteDatabase _db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)_db);
            }

            public void onPostMigrate(SupportSQLiteDatabase _db) {
            }

            protected RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsDonut = new HashMap<String, TableInfo.Column>(4);
                _columnsDonut.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                _columnsDonut.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, 1));
                _columnsDonut.put("description", new TableInfo.Column("description", "TEXT", true, 0, null, 1));
                _columnsDonut.put("rating", new TableInfo.Column("rating", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysDonut = new HashSet(0);
                HashSet _indicesDonut = new HashSet(0);
                TableInfo _infoDonut = new TableInfo("Donut", _columnsDonut, _foreignKeysDonut, _indicesDonut);
                TableInfo _existingDonut = TableInfo.read((SupportSQLiteDatabase)_db, (String)"Donut");
                if (!_infoDonut.equals((Object)_existingDonut)) {
                    return new RoomOpenHelper.ValidationResult(false, "Donut(com.android.samples.donuttracker.core.model.Donut).\n Expected:\n" + _infoDonut + "\n Found:\n" + _existingDonut);
                }
                HashMap<String, TableInfo.Column> _columnsCoffee = new HashMap<String, TableInfo.Column>(4);
                _columnsCoffee.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                _columnsCoffee.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, 1));
                _columnsCoffee.put("description", new TableInfo.Column("description", "TEXT", true, 0, null, 1));
                _columnsCoffee.put("rating", new TableInfo.Column("rating", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysCoffee = new HashSet(0);
                HashSet _indicesCoffee = new HashSet(0);
                TableInfo _infoCoffee = new TableInfo("Coffee", _columnsCoffee, _foreignKeysCoffee, _indicesCoffee);
                TableInfo _existingCoffee = TableInfo.read((SupportSQLiteDatabase)_db, (String)"Coffee");
                if (!_infoCoffee.equals((Object)_existingCoffee)) {
                    return new RoomOpenHelper.ValidationResult(false, "Coffee(com.android.samples.donuttracker.core.model.Coffee).\n Expected:\n" + _infoCoffee + "\n Found:\n" + _existingCoffee);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "459a821437fd5c2f5df3f31248b9e792", "aa5778cd926584c64f7426545a483d42");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"Donut", "Coffee"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `Donut`");
            _db.execSQL("DELETE FROM `Coffee`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        HashMap _typeConvertersMap = new HashMap();
        _typeConvertersMap.put(DonutDao.class, DonutDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(CoffeeDao.class, CoffeeDao_Impl.getRequiredConverters());
        return _typeConvertersMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DonutDao donutDao() {
        if (this._donutDao != null) {
            return this._donutDao;
        }
        SnackDatabase_Impl snackDatabase_Impl = this;
        synchronized (snackDatabase_Impl) {
            if (this._donutDao == null) {
                this._donutDao = new DonutDao_Impl(this);
            }
            return this._donutDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CoffeeDao coffeeDao() {
        if (this._coffeeDao != null) {
            return this._coffeeDao;
        }
        SnackDatabase_Impl snackDatabase_Impl = this;
        synchronized (snackDatabase_Impl) {
            if (this._coffeeDao == null) {
                this._coffeeDao = new CoffeeDao_Impl(this);
            }
            return this._coffeeDao;
        }
    }
}

