package com.android.samples.donuttracker.coffee

import android.os.Bundle
import androidx.navigation.ActionOnlyNavDirections
import androidx.navigation.NavDirections
import kotlin.Int
import kotlin.Long

public class CoffeeListDirections private constructor() {
  private data class ActionCoffeeListToCoffeeEntryDialogFragment(
    public val itemId: Long = -1L
  ) : NavDirections {
    public override val actionId: Int = R.id.action_coffeeList_to_coffeeEntryDialogFragment

    public override val arguments: Bundle
      get() {
        val result = Bundle()
        result.putLong("itemId", this.itemId)
        return result
      }
  }

  public companion object {
    public fun actionCoffeeListToCoffeeEntryDialogFragment(itemId: Long = -1L): NavDirections =
        ActionCoffeeListToCoffeeEntryDialogFragment(itemId)

    public fun actionCoffeeListToCoffeeList2Fragment(): NavDirections =
        ActionOnlyNavDirections(R.id.action_coffeeList_to_coffeeList2Fragment)
  }
}
