package com.android.samples.donuttracker.core.storage;

import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomOpenHelper;
import androidx.room.RoomOpenHelper.Delegate;
import androidx.room.RoomOpenHelper.ValidationResult;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.room.util.TableInfo.Column;
import androidx.room.util.TableInfo.ForeignKey;
import androidx.room.util.TableInfo.Index;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.db.SupportSQLiteOpenHelper.Callback;
import androidx.sqlite.db.SupportSQLiteOpenHelper.Configuration;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SuppressWarnings({"unchecked", "deprecation"})
public final class SnackDatabase_Impl extends SnackDatabase {
  private volatile DonutDao _donutDao;

  private volatile CoffeeDao _coffeeDao;

  @Override
  protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
    final SupportSQLiteOpenHelper.Callback _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(1) {
      @Override
      public void createAllTables(SupportSQLiteDatabase _db) {
        _db.execSQL("CREATE TABLE IF NOT EXISTS `Donut` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `name` TEXT NOT NULL, `description` TEXT NOT NULL, `rating` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `Coffee` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `name` TEXT NOT NULL, `description` TEXT NOT NULL, `rating` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
        _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '459a821437fd5c2f5df3f31248b9e792')");
      }

      @Override
      public void dropAllTables(SupportSQLiteDatabase _db) {
        _db.execSQL("DROP TABLE IF EXISTS `Donut`");
        _db.execSQL("DROP TABLE IF EXISTS `Coffee`");
        if (mCallbacks != null) {
          for (int _i = 0, _size = mCallbacks.size(); _i < _size; _i++) {
            mCallbacks.get(_i).onDestructiveMigration(_db);
          }
        }
      }

      @Override
      protected void onCreate(SupportSQLiteDatabase _db) {
        if (mCallbacks != null) {
          for (int _i = 0, _size = mCallbacks.size(); _i < _size; _i++) {
            mCallbacks.get(_i).onCreate(_db);
          }
        }
      }

      @Override
      public void onOpen(SupportSQLiteDatabase _db) {
        mDatabase = _db;
        internalInitInvalidationTracker(_db);
        if (mCallbacks != null) {
          for (int _i = 0, _size = mCallbacks.size(); _i < _size; _i++) {
            mCallbacks.get(_i).onOpen(_db);
          }
        }
      }

      @Override
      public void onPreMigrate(SupportSQLiteDatabase _db) {
        DBUtil.dropFtsSyncTriggers(_db);
      }

      @Override
      public void onPostMigrate(SupportSQLiteDatabase _db) {
      }

      @Override
      protected RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
        final HashMap<String, TableInfo.Column> _columnsDonut = new HashMap<String, TableInfo.Column>(4);
        _columnsDonut.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDonut.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDonut.put("description", new TableInfo.Column("description", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDonut.put("rating", new TableInfo.Column("rating", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysDonut = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesDonut = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoDonut = new TableInfo("Donut", _columnsDonut, _foreignKeysDonut, _indicesDonut);
        final TableInfo _existingDonut = TableInfo.read(_db, "Donut");
        if (! _infoDonut.equals(_existingDonut)) {
          return new RoomOpenHelper.ValidationResult(false, "Donut(com.android.samples.donuttracker.core.model.Donut).\n"
                  + " Expected:\n" + _infoDonut + "\n"
                  + " Found:\n" + _existingDonut);
        }
        final HashMap<String, TableInfo.Column> _columnsCoffee = new HashMap<String, TableInfo.Column>(4);
        _columnsCoffee.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCoffee.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCoffee.put("description", new TableInfo.Column("description", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCoffee.put("rating", new TableInfo.Column("rating", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysCoffee = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesCoffee = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoCoffee = new TableInfo("Coffee", _columnsCoffee, _foreignKeysCoffee, _indicesCoffee);
        final TableInfo _existingCoffee = TableInfo.read(_db, "Coffee");
        if (! _infoCoffee.equals(_existingCoffee)) {
          return new RoomOpenHelper.ValidationResult(false, "Coffee(com.android.samples.donuttracker.core.model.Coffee).\n"
                  + " Expected:\n" + _infoCoffee + "\n"
                  + " Found:\n" + _existingCoffee);
        }
        return new RoomOpenHelper.ValidationResult(true, null);
      }
    }, "459a821437fd5c2f5df3f31248b9e792", "aa5778cd926584c64f7426545a483d42");
    final SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder(configuration.context)
        .name(configuration.name)
        .callback(_openCallback)
        .build();
    final SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
    return _helper;
  }

  @Override
  protected InvalidationTracker createInvalidationTracker() {
    final HashMap<String, String> _shadowTablesMap = new HashMap<String, String>(0);
    HashMap<String, Set<String>> _viewTables = new HashMap<String, Set<String>>(0);
    return new InvalidationTracker(this, _shadowTablesMap, _viewTables, "Donut","Coffee");
  }

  @Override
  public void clearAllTables() {
    super.assertNotMainThread();
    final SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
    try {
      super.beginTransaction();
      _db.execSQL("DELETE FROM `Donut`");
      _db.execSQL("DELETE FROM `Coffee`");
      super.setTransactionSuccessful();
    } finally {
      super.endTransaction();
      _db.query("PRAGMA wal_checkpoint(FULL)").close();
      if (!_db.inTransaction()) {
        _db.execSQL("VACUUM");
      }
    }
  }

  @Override
  protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
    final HashMap<Class<?>, List<Class<?>>> _typeConvertersMap = new HashMap<Class<?>, List<Class<?>>>();
    _typeConvertersMap.put(DonutDao.class, DonutDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(CoffeeDao.class, CoffeeDao_Impl.getRequiredConverters());
    return _typeConvertersMap;
  }

  @Override
  public DonutDao donutDao() {
    if (_donutDao != null) {
      return _donutDao;
    } else {
      synchronized(this) {
        if(_donutDao == null) {
          _donutDao = new DonutDao_Impl(this);
        }
        return _donutDao;
      }
    }
  }

  @Override
  public CoffeeDao coffeeDao() {
    if (_coffeeDao != null) {
      return _coffeeDao;
    } else {
      synchronized(this) {
        if(_coffeeDao == null) {
          _coffeeDao = new CoffeeDao_Impl(this);
        }
        return _coffeeDao;
      }
    }
  }
}
