package com.example.pointerinputbug

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.compose.foundation.background
import androidx.compose.foundation.border
import androidx.compose.foundation.gestures.detectHorizontalDragGestures
import androidx.compose.foundation.gestures.detectTransformGestures
import androidx.compose.foundation.layout.*
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Icon
import androidx.compose.material.MaterialTheme
import androidx.compose.material.Surface
import androidx.compose.material.Text
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.ArrowForward
import androidx.compose.runtime.*
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.graphicsLayer
import androidx.compose.ui.input.pointer.pointerInput
import androidx.compose.ui.platform.LocalDensity
import androidx.compose.ui.unit.IntOffset
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import com.example.pointerinputbug.ui.theme.PointerInputBugTheme
import kotlin.math.roundToInt

class MainActivity : ComponentActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContent {
            PointerInputBugTheme {
                // A surface container using the 'background' color from the theme
                Surface(color = MaterialTheme.colors.surface, modifier = Modifier.fillMaxSize()) {
                    Transformable()
                }
            }
        }
    }
}

@Composable
private fun Transformable() {
    var offsetX by remember { mutableStateOf(100f) }
    var offsetY by remember { mutableStateOf(100f) }
    var rotation by remember { mutableStateOf(0f) }
    var zoom by remember { mutableStateOf(1f) }
    var width by remember { mutableStateOf(250f) }

    Box(
        modifier = Modifier
            .wrapContentSize(Alignment.TopStart, unbounded = true)
            .offset {
                IntOffset(offsetX.roundToInt(), offsetY.roundToInt())
            }
            .graphicsLayer(scaleX = zoom, scaleY = zoom, rotationZ = rotation)
            .background(Color.Blue)
            .pointerInput(Unit) {
                detectTransformGestures(
                    panZoomLock = false,
                    onGesture = { _, pan, gestureZoom, gestureRotate ->
                        rotation += gestureRotate
                        zoom *= gestureZoom
                        offsetX += pan.x
                        offsetY += pan.y
                    }
                )
            }
    ) {
        val borderShape = RoundedCornerShape(4.dp)

        Box(
            modifier = Modifier
                .width(with(LocalDensity.current) { width.toDp() })
                .border(2.dp, MaterialTheme.colors.onSurface, borderShape)
                .padding(8.dp)
        ) {
            Text("Some text", fontSize = 16.sp, color = Color.White)
        }

        Box(
            modifier = Modifier
                .align(Alignment.BottomEnd)
                .offset(12.dp, 8.dp)
                .background(Color.Red)
                .pointerInput(Unit) {
                    detectHorizontalDragGestures { _, dragAmount ->
                        width += dragAmount
                    }
                }
        ) {
            Icon(
                imageVector = Icons.Default.ArrowForward,
                contentDescription = "Resize"
            )
        }
    }
}
