/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.data;

import com.jsyn.data.AudioSample;
import com.jsyn.data.Function;

public class FloatSample
extends AudioSample
implements Function {
    private float[] buffer;

    public FloatSample() {
    }

    public FloatSample(int numFrames) {
        this(numFrames, 1);
    }

    public FloatSample(float[] data) {
        this(data.length, 1);
        this.write(data);
    }

    public FloatSample(float[] data, int channelsPerFrame) {
        this(data.length / channelsPerFrame, channelsPerFrame);
        this.write(data);
    }

    public FloatSample(int numFrames, int channelsPerFrame) {
        this.allocate(numFrames, channelsPerFrame);
    }

    @Override
    public void allocate(int numFrames, int channelsPerFrame) {
        this.buffer = new float[numFrames * channelsPerFrame];
        this.numFrames = numFrames;
        this.channelsPerFrame = channelsPerFrame;
    }

    public void write(int startFrame, float[] data, int startIndex, int numFrames) {
        int numSamplesToWrite = numFrames * this.channelsPerFrame;
        int firstSampleIndexToWrite = startFrame * this.channelsPerFrame;
        System.arraycopy(data, startIndex, this.buffer, firstSampleIndexToWrite, numSamplesToWrite);
    }

    public void read(int startFrame, float[] data, int startIndex, int numFrames) {
        int numSamplesToRead = numFrames * this.channelsPerFrame;
        int firstSampleIndexToRead = startFrame * this.channelsPerFrame;
        System.arraycopy(this.buffer, firstSampleIndexToRead, data, startIndex, numSamplesToRead);
    }

    public void write(float[] data) {
        this.write(0, data, 0, data.length / this.getChannelsPerFrame());
    }

    public void read(float[] data) {
        this.read(0, data, 0, data.length / this.getChannelsPerFrame());
    }

    @Override
    public double readDouble(int index) {
        return this.buffer[index];
    }

    @Override
    public void writeDouble(int index, double value) {
        this.buffer[index] = (float)value;
    }

    public double interpolate(double fractionalIndex) {
        int index = (int)fractionalIndex;
        float phase = (float)(fractionalIndex - (double)index);
        float source = this.buffer[index];
        float target = this.buffer[index + 1];
        return (target - source) * phase + source;
    }

    @Override
    public double evaluate(double input) {
        double normalizedInput = (input + 1.0) * 0.5;
        if (normalizedInput < 0.0) {
            normalizedInput = 0.0;
        } else if (normalizedInput > 1.0) {
            normalizedInput = 1.0;
        }
        double fractionalIndex = ((double)this.getNumFrames() - 1.01) * normalizedInput;
        return this.interpolate(fractionalIndex);
    }
}

