/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.ports;

import com.jsyn.data.Spectrum;
import com.jsyn.ports.ConnectableInput;
import com.jsyn.ports.ConnectableOutput;
import com.jsyn.ports.PortBlockPart;
import com.jsyn.ports.UnitPort;
import com.jsyn.ports.UnitSpectralOutputPort;

public class UnitSpectralInputPort
extends UnitPort
implements ConnectableInput {
    private UnitSpectralOutputPort other;
    private Spectrum spectrum;

    public UnitSpectralInputPort() {
        this("Output");
    }

    public UnitSpectralInputPort(String name) {
        super(name);
    }

    public void setSpectrum(Spectrum spectrum) {
        this.spectrum = spectrum;
    }

    public Spectrum getSpectrum() {
        if (this.other == null) {
            return this.spectrum;
        }
        return this.other.getSpectrum();
    }

    @Override
    public void connect(ConnectableOutput other) {
        if (!(other instanceof UnitSpectralOutputPort)) {
            throw new RuntimeException("Can only connect UnitSpectralOutputPort to UnitSpectralInputPort!");
        }
        this.other = (UnitSpectralOutputPort)other;
    }

    @Override
    public void disconnect(ConnectableOutput other) {
        if (this.other == other) {
            this.other = null;
        }
    }

    @Override
    public PortBlockPart getPortBlockPart() {
        return null;
    }

    @Override
    public void pullData(long frameCount, int start, int limit) {
        if (this.other != null) {
            this.other.getUnitGenerator().pullData(frameCount, start, limit);
        }
    }

    public boolean isAvailable() {
        if (this.other != null) {
            return this.other.isAvailable();
        }
        return this.spectrum != null;
    }
}

