/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.TunableFilter;

public abstract class FilterBiquad
extends TunableFilter {
    public UnitInputPort amplitude = new UnitInputPort("Amplitude", 1.0);
    protected static final double MINIMUM_FREQUENCY = 1.0E-5;
    protected static final double MINIMUM_GAIN = 1.0E-5;
    protected static final double RATIO_MINIMUM = 0.499;
    protected double a0;
    protected double a1;
    protected double a2;
    protected double b1;
    protected double b2;
    private double x1;
    private double x2;
    private double y1;
    private double y2;
    protected double previousFrequency;
    protected double omega;
    protected double sin_omega;
    protected double cos_omega;

    public FilterBiquad() {
        this.addPort(this.amplitude);
    }

    @Override
    public void generate(int start, int limit) {
        this.recalculate();
        this.performBiquadFilter(start, limit);
    }

    protected abstract void recalculate();

    public void performBiquadFilter(int start, int limit) {
        double[] inputs = this.input.getValues();
        double[] amplitudes = this.amplitude.getValues();
        double[] outputs = this.output.getValues();
        double x1_jsyn = this.x1;
        double x2_jsyn = this.x2;
        double y1_jsyn = this.y1;
        double y2_jsyn = this.y2;
        double a0_jsyn = this.a0;
        double a1_jsyn = this.a1;
        double a2_jsyn = this.a2;
        double b1_jsyn = this.b1;
        double b2_jsyn = this.b2;
        for (int i = start; i < limit; i += 2) {
            double x0_jsyn = inputs[i];
            y2_jsyn = a0_jsyn * x0_jsyn + a1_jsyn * x1_jsyn + a2_jsyn * x2_jsyn - b1_jsyn * y1_jsyn - b2_jsyn * y2_jsyn;
            outputs[i] = amplitudes[i] * y2_jsyn;
            x2_jsyn = inputs[i + 1];
            y1_jsyn = a0_jsyn * x2_jsyn + a1_jsyn * x0_jsyn + a2_jsyn * x1_jsyn - b1_jsyn * y2_jsyn - b2_jsyn * y1_jsyn;
            outputs[i + 1] = amplitudes[i + 1] * y1_jsyn;
            x1_jsyn = x2_jsyn;
            x2_jsyn = x0_jsyn;
        }
        this.x1 = x1_jsyn;
        this.x2 = x2_jsyn;
        this.y1 = y1_jsyn + 1.0E-26;
        this.y2 = y2_jsyn - 1.0E-26;
    }

    protected void calculateOmega(double ratio) {
        if (ratio >= 0.499) {
            ratio = 0.499;
        }
        this.omega = Math.PI * 2 * ratio;
        this.cos_omega = Math.cos(this.omega);
        this.sin_omega = Math.sin(this.omega);
    }
}

