/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.Synthesizer;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.ExponentialRamp;
import com.jsyn.unitgen.LinearRamp;
import com.jsyn.unitgen.Multiply;
import com.jsyn.unitgen.Pan;
import com.jsyn.unitgen.PowerOfTwo;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.TwoInDualOut;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.unitgen.UnitOscillator;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.util.VoiceAllocator;
import com.jsyn.util.VoiceDescription;
import com.jsyn.util.VoiceOperation;
import com.softsynth.math.AudioMath;
import com.softsynth.shared.time.TimeStamp;

public class MultiChannelSynthesizer {
    private Synthesizer synth;
    private TwoInDualOut outputUnit;
    private ChannelContext[] channels;
    private static final int MAX_VELOCITY = 127;
    private static final int DEFAULT_RHYTHM_CHANNEL = 9;
    private static final int RHYTHM_PRESET = 128;
    private double mMasterAmplitude = 0.25;

    public MultiChannelSynthesizer() {
        this(16);
    }

    public MultiChannelSynthesizer(int maxChannels) {
        this.channels = new ChannelContext[maxChannels];
        for (int i = 0; i < this.channels.length; ++i) {
            this.channels[i] = new ChannelContext(i);
        }
    }

    public void setup(Synthesizer synth, int startChannel, int numChannels, int voicesPerChannel, VoiceDescription voiceDescription) {
        this.synth = synth;
        if (this.outputUnit == null) {
            this.outputUnit = new TwoInDualOut();
            synth.add(this.outputUnit);
        }
        int voicesPerChannelGroupContext = numChannels * voicesPerChannel;
        ChannelGroupContext groupContext = new ChannelGroupContext(voicesPerChannelGroupContext, voiceDescription);
        for (int i = 0; i < numChannels; ++i) {
            this.channels[startChannel + i].setup(groupContext);
        }
    }

    public void programChange(int channel, int program) {
        ChannelContext channelContext = this.channels[channel];
        channelContext.programChange(program);
    }

    public void noteOff(int channel, int noteNumber, int velocity) {
        double amplitude = (double)velocity * 0.007874015748031496;
        this.noteOff(channel, noteNumber, amplitude);
    }

    public void noteOff(int channel, int noteNumber, double amplitude) {
        ChannelContext channelContext = this.channels[channel];
        channelContext.noteOff(noteNumber, amplitude * this.mMasterAmplitude);
    }

    public void noteOff(int channel, int noteNumber, double amplitude, TimeStamp timeStamp) {
        ChannelContext channelContext = this.channels[channel];
        channelContext.noteOff(noteNumber, amplitude * this.mMasterAmplitude, timeStamp);
    }

    public void noteOn(int channel, int noteNumber, int velocity) {
        double amplitude = (double)velocity * 0.007874015748031496;
        this.noteOn(channel, noteNumber, amplitude);
    }

    public void noteOn(int channel, int noteNumber, double amplitude, TimeStamp timeStamp) {
        ChannelContext channelContext = this.channels[channel];
        channelContext.noteOn(noteNumber, amplitude * this.mMasterAmplitude, timeStamp);
    }

    public void noteOn(int channel, int noteNumber, double amplitude) {
        ChannelContext channelContext = this.channels[channel];
        channelContext.noteOn(noteNumber, amplitude * this.mMasterAmplitude);
    }

    public void setPitchBend(int channel, double offset) {
        ChannelContext channelContext = this.channels[channel];
        channelContext.setPitchBend(offset);
    }

    public void setBendRange(int channel, double semitones) {
        ChannelContext channelContext = this.channels[channel];
        channelContext.setBendRange(semitones);
    }

    public void setPressure(int channel, double pressure) {
        ChannelContext channelContext = this.channels[channel];
        channelContext.setPressure(pressure);
    }

    public void setVibratoDepth(int channel, double semitones) {
        ChannelContext channelContext = this.channels[channel];
        channelContext.setVibratoDepth(semitones);
    }

    public void setTimbre(int channel, double timbre) {
        ChannelContext channelContext = this.channels[channel];
        channelContext.setTimbre(timbre);
    }

    public void setVolume(int channel, double volume) {
        ChannelContext channelContext = this.channels[channel];
        channelContext.setVolume(volume);
    }

    public void setPan(int channel, double pan) {
        ChannelContext channelContext = this.channels[channel];
        channelContext.setPan(pan);
    }

    public UnitOutputPort getOutput() {
        return this.outputUnit.output;
    }

    public void setMasterAmplitude(double masterAmplitude) {
        this.mMasterAmplitude = masterAmplitude;
    }

    public double getMasterAmplitude() {
        return this.mMasterAmplitude;
    }

    private class ChannelContext {
        private UnitOscillator lfo;
        private PowerOfTwo pitchToLinear;
        private LinearRamp timbreRamp;
        private LinearRamp pressureRamp;
        private ExponentialRamp volumeRamp;
        private Multiply volumeMultiplier;
        private Pan panner;
        private double vibratoRate = 5.0;
        private double bendRangeOctaves = 0.16666666666666666;
        private int presetIndex;
        private ChannelGroupContext groupContext;
        private int channelIndex;
        private boolean rhythm;
        VoiceOperation voiceOperation = new VoiceOperation(){

            @Override
            public void operate(UnitVoice voice) {
                voice.usePreset(ChannelContext.this.presetIndex);
                ChannelContext.this.connectVoice(voice);
            }
        };

        ChannelContext(int channelIndex) {
            this.channelIndex = channelIndex;
            if (channelIndex == 9) {
                this.rhythm = true;
                this.presetIndex = 128;
            }
        }

        void setup(ChannelGroupContext groupContext) {
            this.groupContext = groupContext;
            this.pitchToLinear = new PowerOfTwo();
            MultiChannelSynthesizer.this.synth.add(this.pitchToLinear);
            this.lfo = new SineOscillator();
            MultiChannelSynthesizer.this.synth.add(this.lfo);
            this.timbreRamp = new LinearRamp();
            MultiChannelSynthesizer.this.synth.add(this.timbreRamp);
            this.timbreRamp.time.set(0.02);
            this.pressureRamp = new LinearRamp();
            MultiChannelSynthesizer.this.synth.add(this.pressureRamp);
            this.pressureRamp.time.set(0.02);
            this.volumeRamp = new ExponentialRamp();
            MultiChannelSynthesizer.this.synth.add(this.volumeRamp);
            this.volumeRamp.input.set(1.0);
            this.volumeRamp.time.set(0.02);
            this.volumeMultiplier = new Multiply();
            MultiChannelSynthesizer.this.synth.add(this.volumeMultiplier);
            this.panner = new Pan();
            MultiChannelSynthesizer.this.synth.add(this.panner);
            this.pitchToLinear.input.setValueAdded(true);
            this.lfo.output.connect(this.pitchToLinear.input);
            this.lfo.amplitude.set(0.0);
            this.lfo.frequency.set(this.vibratoRate);
            this.volumeRamp.output.connect(this.volumeMultiplier.inputB);
            this.volumeMultiplier.output.connect(this.panner.input);
            this.panner.output.connect(0, ((MultiChannelSynthesizer)MultiChannelSynthesizer.this).outputUnit.inputA, 0);
            this.panner.output.connect(1, ((MultiChannelSynthesizer)MultiChannelSynthesizer.this).outputUnit.inputB, 0);
        }

        private void connectVoice(UnitVoice voice) {
            UnitInputPort pressurePort;
            UnitInputPort timbrePort;
            UnitGenerator ugen = voice.getUnitGenerator();
            UnitInputPort freqMod = (UnitInputPort)ugen.getPortByName("FreqScaler");
            if (freqMod != null) {
                freqMod.disconnectAll();
                this.pitchToLinear.output.connect(freqMod);
            }
            if ((timbrePort = (UnitInputPort)ugen.getPortByName("Timbre")) != null) {
                timbrePort.disconnectAll();
                this.timbreRamp.output.connect(timbrePort);
                this.timbreRamp.input.setup(timbrePort);
            }
            if ((pressurePort = (UnitInputPort)ugen.getPortByName("Pressure")) != null) {
                pressurePort.disconnectAll();
                this.pressureRamp.output.connect(pressurePort);
                this.pressureRamp.input.setup(pressurePort);
            }
            voice.getOutput().disconnectAll();
            voice.getOutput().connect(this.volumeMultiplier.inputA);
        }

        void programChange(int program) {
            if (!this.rhythm) {
                int programWrapped = program % this.groupContext.voiceDescription.getPresetCount();
                String name = this.groupContext.voiceDescription.getPresetNames()[programWrapped];
                this.presetIndex = programWrapped;
            }
        }

        private int makeNoteTag(int noteNumber) {
            return (this.channelIndex << 8) + noteNumber;
        }

        void noteOff(int noteNumber, double amplitude) {
            this.noteOff(noteNumber, amplitude, MultiChannelSynthesizer.this.synth.createTimeStamp());
        }

        void noteOff(int noteNumber, double amplitude, TimeStamp timeStamp) {
            this.groupContext.allocator.noteOff(this.makeNoteTag(noteNumber), timeStamp);
        }

        void noteOn(int noteNumber, double amplitude) {
            this.noteOn(noteNumber, amplitude, MultiChannelSynthesizer.this.synth.createTimeStamp());
        }

        void noteOn(int noteNumber, double amplitude, TimeStamp timeStamp) {
            double frequency = AudioMath.pitchToFrequency(noteNumber);
            this.groupContext.allocator.noteOn(this.makeNoteTag(noteNumber), frequency, amplitude, this.voiceOperation, timeStamp);
        }

        public void setPitchBend(double offset) {
            this.pitchToLinear.input.set(this.bendRangeOctaves * offset);
        }

        public void setBendRange(double semitones) {
            this.bendRangeOctaves = semitones / 12.0;
        }

        public void setVibratoDepth(double semitones) {
            this.lfo.amplitude.set(semitones);
        }

        public void setVolume(double volume) {
            double min = 1.5848931924611107E-5;
            double max = 1.0;
            double ratio = max / min;
            double value = min * Math.pow(ratio, volume);
            this.volumeRamp.input.set(value);
        }

        public void setPan(double pan) {
            this.panner.pan.set(pan);
        }

        public void setTimbre(double timbre) {
            double min = this.timbreRamp.input.getMinimum();
            double max = this.timbreRamp.input.getMaximum();
            double value = min + timbre * (max - min);
            this.timbreRamp.input.set(value);
        }

        public void setPressure(double pressure) {
            double min = this.pressureRamp.input.getMinimum();
            double max = this.pressureRamp.input.getMaximum();
            double ratio = max / min;
            double value = min * Math.pow(ratio, pressure);
            this.pressureRamp.input.set(value);
        }
    }

    private class ChannelGroupContext {
        private VoiceDescription voiceDescription;
        private UnitVoice[] voices;
        private VoiceAllocator allocator;

        ChannelGroupContext(int numVoices, VoiceDescription voiceDescription) {
            this.voiceDescription = voiceDescription;
            this.voices = new UnitVoice[numVoices];
            for (int i = 0; i < numVoices; ++i) {
                UnitVoice voice = voiceDescription.createUnitVoice();
                UnitGenerator ugen = voice.getUnitGenerator();
                MultiChannelSynthesizer.this.synth.add(ugen);
                this.voices[i] = voice;
            }
            this.allocator = new VoiceAllocator(this.voices);
        }
    }
}

