/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.math;

public class FourierMath {
    private static final int MAX_SIZE_LOG_2 = 16;
    static BitReverseTable[] reverseTables = new BitReverseTable[16];
    static DoubleSineTable[] sineTables = new DoubleSineTable[16];
    static FloatSineTable[] floatSineTables = new FloatSineTable[16];

    private static double[] getDoubleSineTable(int n) {
        DoubleSineTable sineTable = sineTables[n];
        if (sineTable == null) {
            FourierMath.sineTables[n] = sineTable = new DoubleSineTable(n);
        }
        return sineTable.sineValues;
    }

    private static float[] getFloatSineTable(int n) {
        FloatSineTable sineTable = floatSineTables[n];
        if (sineTable == null) {
            FourierMath.floatSineTables[n] = sineTable = new FloatSineTable(n);
        }
        return sineTable.sineValues;
    }

    private static int[] getReverseTable(int n) {
        BitReverseTable reverseTable = reverseTables[n];
        if (reverseTable == null) {
            FourierMath.reverseTables[n] = reverseTable = new BitReverseTable(n);
        }
        return reverseTable.reversedBits;
    }

    public static void calculateMagnitudes(double[] ar, double[] ai, double[] magnitudes) {
        for (int i = 0; i < magnitudes.length; ++i) {
            magnitudes[i] = Math.sqrt(ar[i] * ar[i] + ai[i] * ai[i]);
        }
    }

    public static void calculateMagnitudes(float[] ar, float[] ai, float[] magnitudes) {
        for (int i = 0; i < magnitudes.length; ++i) {
            magnitudes[i] = (float)Math.sqrt(ar[i] * ar[i] + ai[i] * ai[i]);
        }
    }

    public static void transform(int sign, int n, double[] ar, double[] ai) {
        int j;
        int i;
        double scale = sign > 0 ? 2.0 / (double)n : 0.5;
        int numBits = FourierMath.numBits(n);
        int[] reverseTable = FourierMath.getReverseTable(numBits);
        double[] sineTable = FourierMath.getDoubleSineTable(numBits);
        int mask = n - 1;
        int cosineOffset = n / 4;
        for (i = 0; i < n; ++i) {
            j = reverseTable[i];
            if (j < i) continue;
            double tempr = ar[j] * scale;
            double tempi = ai[j] * scale;
            ar[j] = ar[i] * scale;
            ai[j] = ai[i] * scale;
            ar[i] = tempr;
            ai[i] = tempi;
        }
        int numerator = sign * n;
        int mmax = 1;
        int stride = 2 * mmax;
        while (mmax < n) {
            int phase = 0;
            int phaseIncrement = numerator / (2 * mmax);
            for (int m = 0; m < mmax; ++m) {
                double wr = sineTable[phase + cosineOffset & mask];
                double wi = sineTable[phase];
                for (i = m; i < n; i += stride) {
                    j = i + mmax;
                    double tr = wr * ar[j] - wi * ai[j];
                    double ti = wr * ai[j] + wi * ar[j];
                    ar[j] = ar[i] - tr;
                    ai[j] = ai[i] - ti;
                    int n2 = i;
                    ar[n2] = ar[n2] + tr;
                    int n3 = i;
                    ai[n3] = ai[n3] + ti;
                }
                phase = phase + phaseIncrement & mask;
            }
            mmax = stride;
            mmax = stride;
            stride = 2 * mmax;
        }
    }

    public static void transform(int sign, int n, float[] ar, float[] ai) {
        int j;
        int i;
        float scale = sign > 0 ? 2.0f / (float)n : 0.5f;
        int numBits = FourierMath.numBits(n);
        int[] reverseTable = FourierMath.getReverseTable(numBits);
        float[] sineTable = FourierMath.getFloatSineTable(numBits);
        int mask = n - 1;
        int cosineOffset = n / 4;
        for (i = 0; i < n; ++i) {
            j = reverseTable[i];
            if (j < i) continue;
            float tempr = ar[j] * scale;
            float tempi = ai[j] * scale;
            ar[j] = ar[i] * scale;
            ai[j] = ai[i] * scale;
            ar[i] = tempr;
            ai[i] = tempi;
        }
        int numerator = sign * n;
        int mmax = 1;
        int stride = 2 * mmax;
        while (mmax < n) {
            int phase = 0;
            int phaseIncrement = numerator / (2 * mmax);
            for (int m = 0; m < mmax; ++m) {
                float wr = sineTable[phase + cosineOffset & mask];
                float wi = sineTable[phase];
                for (i = m; i < n; i += stride) {
                    j = i + mmax;
                    float tr = wr * ar[j] - wi * ai[j];
                    float ti = wr * ai[j] + wi * ar[j];
                    ar[j] = ar[i] - tr;
                    ai[j] = ai[i] - ti;
                    int n2 = i;
                    ar[n2] = ar[n2] + tr;
                    int n3 = i;
                    ai[n3] = ai[n3] + ti;
                }
                phase = phase + phaseIncrement & mask;
            }
            mmax = stride;
            mmax = stride;
            stride = 2 * mmax;
        }
    }

    public static int numBits(int powerOf2) {
        assert ((powerOf2 & powerOf2 - 1) == 0);
        int i = -1;
        while (powerOf2 > 0) {
            powerOf2 >>= 1;
            ++i;
        }
        return i;
    }

    public static void fft(int n, double[] ar, double[] ai) {
        FourierMath.transform(1, n, ar, ai);
    }

    public static void ifft(int n, double[] ar, double[] ai) {
        FourierMath.transform(-1, n, ar, ai);
    }

    private static class BitReverseTable {
        int[] reversedBits;

        BitReverseTable(int numBits) {
            this.reversedBits = new int[1 << numBits];
            for (int i = 0; i < this.reversedBits.length; ++i) {
                this.reversedBits[i] = BitReverseTable.reverseBits(i, numBits);
            }
        }

        static int reverseBits(int index, int numBits) {
            int rev = 0;
            for (int i = 0; i < numBits; ++i) {
                rev = rev << 1 | index & 1;
                index >>= 1;
            }
            return rev;
        }
    }

    private static class FloatSineTable {
        float[] sineValues;

        FloatSineTable(int numBits) {
            int len = 1 << numBits;
            this.sineValues = new float[1 << numBits];
            for (int i = 0; i < len; ++i) {
                this.sineValues[i] = (float)Math.sin((double)i * Math.PI * 2.0 / (double)len);
            }
        }
    }

    private static class DoubleSineTable {
        double[] sineValues;

        DoubleSineTable(int numBits) {
            int len = 1 << numBits;
            this.sineValues = new double[1 << numBits];
            for (int i = 0; i < len; ++i) {
                this.sineValues[i] = Math.sin((double)i * Math.PI * 2.0 / (double)len);
            }
        }
    }
}

