package jess.fragmentbugproject

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.widget.Button
import androidx.transition.Fade

class MainActivity : AppCompatActivity() {
    val fragmentTag = "MyFragment"
    val fragment = SimpleFragment()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)

        supportFragmentManager.beginTransaction().apply {
            add(R.id.fragment_container, fragment, fragmentTag)
            commit()
        }

        findViewById<Button>(R.id.hide_button).setOnClickListener {
            supportFragmentManager.beginTransaction().apply {
                fragment.exitTransition = Fade()
                hide(fragment)
                commitNowAllowingStateLoss()
            }
        }
    }
}