package dev.carmona.compose

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.material.Button
import androidx.compose.material.MaterialTheme
import androidx.compose.material.Surface
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.navigation.NavController
import androidx.navigation.compose.NavHost
import androidx.navigation.compose.composable
import androidx.navigation.compose.rememberNavController
import dev.carmona.compose.ui.theme.ComposePopUpToCrashTheme

private const val ROUTE_COMPOSABLE_A = "ComposableA"
private const val ROUTE_COMPOSABLE_B = "ComposableB"

class MainActivity : ComponentActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContent {
            ComposePopUpToCrashTheme {
                // A surface container using the 'background' color from the theme
                Surface(color = MaterialTheme.colors.background) {
                    val navController = rememberNavController()
                    NavHost(navController, startDestination = ROUTE_COMPOSABLE_A) {
                        composable(route = ROUTE_COMPOSABLE_A) {
                            ComposableA(navController)
                        }
                        composable(route = ROUTE_COMPOSABLE_B) {
                            ComposableB()
                        }
                    }
                }
            }
        }
    }
}

@Composable
fun ComposableA(navController: NavController) {
    Box(modifier = Modifier.fillMaxSize()) {
        Button(
            modifier = Modifier.align(Alignment.Center),
            onClick = {
                navController.navigate(ROUTE_COMPOSABLE_B) {
                    popUpTo(ROUTE_COMPOSABLE_A) { inclusive = true }
                }
            }
        ) {
            Text(text = "Composable A")
        }
    }
}

@Composable
fun ComposableB() {
    Box(modifier = Modifier.fillMaxSize()) {
        Button(
            modifier = Modifier.align(Alignment.Center),
            onClick = { }
        ) {
            Text(text = "Composable B")
        }
    }
}
