package com.oodrive.keyboardbug.ui.main

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import androidx.appcompat.app.AppCompatActivity
import androidx.fragment.app.Fragment
import com.oodrive.keyboardbug.R

class MainFragment : Fragment() {

    companion object {
        fun newInstance() = MainFragment()
    }

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        return inflater.inflate(R.layout.main_fragment, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        view.findViewById<Button>(R.id.nextScreen).setOnClickListener {
            requireActivity().supportFragmentManager.beginTransaction().apply {
                setCustomAnimations(
                    R.anim.fragment_appear,
                    R.anim.slide_fade_out,
                    R.anim.slide_fade_in,
                    R.anim.fragment_disappear
                )
                replace(
                    R.id.container,
                    FragmentWithRecyclerView.newInstance(),
                    FragmentWithRecyclerView.javaClass.name
                )
                addToBackStack(null)
                commit()
            }
        }

        (requireActivity() as AppCompatActivity).supportActionBar?.setTitle(R.string.app_name)
    }

}