package gmk57.testactivityresult

import android.app.Activity
import android.content.ActivityNotFoundException
import android.content.Intent
import android.os.Bundle
import android.util.Log
import android.widget.Button
import android.widget.Toast
import androidx.activity.result.ActivityResult
import androidx.activity.result.contract.ActivityResultContracts
import androidx.appcompat.app.AppCompatActivity

private const val TAG = "MainActivity"

class MainActivity : AppCompatActivity(R.layout.activity_main) {
    private val startForResult =
        registerForActivityResult(ActivityResultContracts.StartActivityForResult()) { result: ActivityResult ->
            Log.i(TAG, "got result: $result")
            if (result.resultCode == Activity.RESULT_OK) {
                val intent = result.data
                // Handle the Intent
            } else {
                Toast.makeText(this, "User has cancelled the request", Toast.LENGTH_LONG).show()
            }
        }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        val startButton = findViewById<Button>(R.id.start_button)

        startButton.setOnClickListener {
            try {
                startForResult.launch(Intent("some action"))
            } catch (e: ActivityNotFoundException) {
                // Define what your app should do if no activity can handle the intent.
                Log.e(TAG, "startForResult.launch failed: $e")
                Toast.makeText(this, "No app can handle the intent", Toast.LENGTH_LONG).show()
            }
        }
    }
}
