package com.mapbox.example.hellocar

import android.content.Intent
import androidx.car.app.CarAppService
import androidx.car.app.CarContext
import androidx.car.app.Screen
import androidx.car.app.Session
import androidx.car.app.model.Action
import androidx.car.app.model.MessageTemplate
import androidx.car.app.model.Template
import androidx.car.app.validation.HostValidator

class MainCarAppService : CarAppService() {
    override fun createHostValidator(): HostValidator {
        return HostValidator.ALLOW_ALL_HOSTS_VALIDATOR
    }

    override fun onCreateSession(): Session {
        return object : Session() {
            override fun onCreateScreen(intent: Intent): Screen {
                return createNothingScreen(carContext)
            }
        }
    }

    private fun createNothingScreen(carContext: CarContext): Screen {
        return object : Screen(carContext) {
            override fun onGetTemplate(): Template {
                return MessageTemplate.Builder(
                    "Empty message"
                ).setTitle(
                    "Empty title"
                ).addAction(
                    Action.Builder()
                        .setTitle("ok")
                        .setOnClickListener {
                            carContext.finishCarApp()
                        }.build()
                ).build()
            }
        }
    }
}
