package com.example.myapplication;

import android.content.Context;
import android.content.SharedPreferences;

public class MySingletonPref {

    private static MySingletonPref INSTANCE = null;
    private final SharedPreferences mSharedPreferences;
    private final PrefRepository mRepository;
    private String keyPref = "com.traveloka.android.pref_user_country";
    private String name = "pref_user.name";

    // other instance variables can be here

    private MySingletonPref(Context context) {
        mRepository = new PrefRepository(context);
        mSharedPreferences =
                mRepository.getPref(keyPref);
    }

    public static MySingletonPref getInstance(Context context) {
        if (INSTANCE == null) {
            INSTANCE = new MySingletonPref(context);
        }
        return (INSTANCE);
    }

    public void changePref() {
        mRepository.write(mSharedPreferences, name, System.currentTimeMillis());
    }

    public void setListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        mSharedPreferences.registerOnSharedPreferenceChangeListener(listener);
    }


}
