package com.example.myapplication;

import android.content.Context;
import android.content.SharedPreferences;


import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by ahmadfadli on 8/11/15.
 */
public class PrefRepository implements SharedPreferenceRepository {
    private final Context mContext;

    public PrefRepository(Context context) {
        mContext = context;
    }

    @Override
    public SharedPreferences getPref(String fileName) {
        try {
            return mContext.getSharedPreferences(fileName, Context.MODE_PRIVATE);
        } catch (NullPointerException e) {
            e.printStackTrace();
            return null;
        }
    }


    //region WRITE
    @Override
    public boolean write(SharedPreferences pref, String key, Object value) {
        if (pref != null) {
            SharedPreferences.Editor editor = pref.edit();
            writeToEditor(editor, key, value);
            return editor.commit();
        }
        return false;
    }

    @Override
    public boolean write(SharedPreferences pref, Map<String, ?> values) {
        if (pref != null) {
            SharedPreferences.Editor editor = pref.edit();
            for (Map.Entry<String, ?> value : values.entrySet()) {
                writeToEditor(editor, value.getKey(), value.getValue());
            }
            return editor.commit();
        }
        return false;
    }

    private void writeToEditor(SharedPreferences.Editor editor, String key, Object value) {
        if (editor != null) {
            if (value instanceof Integer) {
                editor.putInt(key, (Integer) value);
            } else if (value instanceof String) {
                editor.putString(key, String.valueOf(value));
            } else if (value instanceof Boolean) {
                editor.putBoolean(key, (Boolean) value);
            } else if (value instanceof Float) {
                editor.putFloat(key, (Float) value);
            } else if (value instanceof Double) {
                editor.putFloat(key, ((Double) value).floatValue());
            } else if (value instanceof Long) {
                editor.putLong(key, (Long) value);
            }
        }
    }
    //endregion

    //region READ
    @Override
    public Map<String, Object> get(SharedPreferences pref, Map<String, ?> keyAndDefault) {
        Map<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, ?> entry : keyAndDefault.entrySet()) {
            Object entryResult = null;
            Object defaultValue = entry.getValue();
            if (defaultValue instanceof String) {
                entryResult = getString(pref, entry.getKey(), (String) defaultValue);
            } else if (defaultValue instanceof Boolean) {
                entryResult = getBoolean(pref, entry.getKey(), (Boolean) defaultValue);
            } else if (defaultValue instanceof Integer) {
                entryResult = getInteger(pref, entry.getKey(), (Integer) defaultValue);
            } else if (defaultValue instanceof Float) {
                entryResult = getFloat(pref, entry.getKey(), (Float) defaultValue);
            } else if (defaultValue instanceof Long) {
                entryResult = getLong(pref, entry.getKey(), (Long) defaultValue);
            }
            result.put(entry.getKey(), entryResult);
        }
        return result;
    }


    @Override
    public Boolean getBoolean(SharedPreferences pref, String key, Boolean defaultValue) {
        return pref != null && pref.getBoolean(key, defaultValue);
    }

    @Override
    public String getString(SharedPreferences pref, String key, String defaultValue) {
        return pref != null ? pref.getString(key, defaultValue) : defaultValue;
    }

    @Override
    public Integer getInteger(SharedPreferences pref, String key, Integer defaultValue) {
        return pref != null ? pref.getInt(key, defaultValue) : defaultValue;
    }

    @Override
    public Float getFloat(SharedPreferences pref, String key, Float defaultValue) {
        return pref != null ? pref.getFloat(key, defaultValue) : defaultValue;
    }

    @Override
    public Long getLong(SharedPreferences pref, String key, Long defaultValue) {
        return pref != null ? pref.getLong(key, defaultValue) : defaultValue;
    }
    //endregion

    //region DELETE
    @Override
    public boolean delete(SharedPreferences pref, List<String> keys) {
        if (pref != null) {
            SharedPreferences.Editor editor = pref.edit();
            for (String key : keys) {
                editor.remove(key);
            }
            return editor.commit();
        }
        return false;
    }

    @Override
    public boolean delete(SharedPreferences pref, String key) {
        if (pref != null) {
            SharedPreferences.Editor editor = pref.edit();
            editor.remove(key);
            return editor.commit();
        }
        return false;
    }

    @Override
    public boolean delete(SharedPreferences pref) {
        if (pref != null) {
            SharedPreferences.Editor editor = pref.edit();
            editor.clear();
            return editor.commit();
        }
        return false;
    }
    //endregion
}
