package com.example.myapplication;

import android.content.SharedPreferences;

import java.util.List;
import java.util.Map;

public interface SharedPreferenceRepository {
    SharedPreferences getPref(String fileName);


    boolean write(SharedPreferences pref, String key, Object value);

    boolean write(SharedPreferences pref, Map<String, ?> values);

    Map get(SharedPreferences pref, Map<String, ?> keyAndDefault);

    Boolean getBoolean(SharedPreferences pref, String key, Boolean defaultValue);

    String getString(SharedPreferences pref, String key, String defaultValue);

    Integer getInteger(SharedPreferences pref, String key, Integer defaultValue);

    Float getFloat(SharedPreferences pref, String key, Float defaultValue);

    Long getLong(SharedPreferences pref, String key, Long defaultValue);

    boolean delete(SharedPreferences pref, List<String> keys);

    boolean delete(SharedPreferences pref, String key);

    boolean delete(SharedPreferences pref);
}
