package com.example.myapplication;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.LOCAL_VARIABLE;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.ElementType.TYPE;

import android.content.Context;
import android.os.Bundle;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public class MainActivity extends AppCompatActivity {
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        System.out.println("~~~~ Inflating views....");
        AnnotationInflation.createView(this, ScreenType1.class, null);
        AnnotationInflation.createView(this, ScreenType2.class, null);
    }

    @Layout(R.layout.used17)
    @Retention(RetentionPolicy.RUNTIME)
    @Target({METHOD, PARAMETER, TYPE, LOCAL_VARIABLE, FIELD})
    public @interface Indirect {
        int[] value();
    }

    @Layout(R.layout.used16)
    private static class ScreenType1 {
    }

    @Indirect(5)
    @Layouts({R.layout.used18,R.layout.used19})
    private static class ScreenType2 {
    }
}