package dev.olshevski.navigationoptionalargumentissue

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.material.Button
import androidx.compose.material.MaterialTheme
import androidx.compose.material.Surface
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import androidx.navigation.compose.NavHost
import androidx.navigation.compose.composable
import androidx.navigation.compose.rememberNavController
import androidx.navigation.navArgument
import dev.olshevski.navigationoptionalargumentissue.ui.theme.NavigationOptionalArgumentIssueTheme

class MainActivity : ComponentActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContent {
            NavigationOptionalArgumentIssueTheme {
                // A surface container using the 'background' color from the theme
                Surface(color = MaterialTheme.colors.background) {
                    MainNavHost()
                }
            }
        }
    }
}

@Composable
fun MainNavHost() {
    val navController = rememberNavController()
    NavHost(navController = navController, startDestination = "main") {

        composable("main") {
            ScreenWithTitle(title = "Main") {

                Column {
                    Button(onClick = {
                        navController.navigate("secondary?param=param")
                    }) {
                        Text("To secondary with param=param")
                    }

                    Button(onClick = {
                        navController.navigate("secondary?param=otherValue")
                    }) {
                        Text("To secondary with param=otherValue")
                    }
                }
            }
        }

        composable(
            route = "secondary?param={param}",
            arguments = listOf(navArgument("param") {
                nullable = true
            })
        ) {
            ScreenWithTitle(title = "Secondary") {
                val arg = it.arguments!!.getString("param")
                Text("param=$arg")
            }
        }

    }
}

@Composable
fun ScreenWithTitle(title: String, content: @Composable () -> Unit = {}) {
    Column(Modifier.fillMaxSize()) {
        Text(
            text = title,
            modifier = Modifier
                .align(Alignment.CenterHorizontally)
                .padding(16.dp),
            style = MaterialTheme.typography.h5
        )
        content()
    }
}
