package me.monori.network

import okhttp3.Interceptor
import okhttp3.Response

internal class TestInterceptor(val lambda: (String) -> Unit) : Interceptor {
    override fun intercept(chain: Interceptor.Chain): Response {
        val response = chain.proceed(chain.request())

        if (response.code == 410) {
            val encodedPath = response.request.url.encodedPath
            lambda(encodedPath)
        }
        return response
    }
}