//
//  ViewController.swift
//  MarkerVoiceover
//
//  Created by Jacob Strickler on 12/2/21.
//

import GoogleMaps
import UIKit

class ViewController: UIViewController {

    @IBOutlet var mapView: GMSMapView!

    var markerCoordinates = [
        (39.101542, -84.516391),
        (39.101954, -84.517486),
        (39.100471, -84.518284),
        (39.098845, -84.519070),
        (39.102331, -84.518451),
        (39.099507, -84.515852),
        (39.098386, -84.517260),
        (39.100934, -84.520481),
        (39.098672, -84.520334),
        (39.097883, -84.517319),
    ]

    override func viewDidLoad() {
        super.viewDidLoad()

        // Set the camera position
        mapView.camera = GMSCameraPosition.camera(
            withLatitude: 39.101114,
            longitude: -84.520697,
            zoom: 15
        )

        // Add a few markers
        for coordinate in markerCoordinates {
            let marker = GMSMarker()
            marker.position = CLLocationCoordinate2D(
                latitude: coordinate.0,
                longitude: coordinate.1
            )
            marker.map = mapView
        }

        // Show the accessibility elements
        mapView.accessibilityElementsHidden = false
    }
}
