plugins {
    id("com.android.application")
    id("kotlin-android")
    id("dagger.hilt.android.plugin")
    kotlin("kapt")
}

android {
    setCompileSdkVersion(31)
    buildToolsVersion = "31.0.0"

    defaultConfig {
        testInstrumentationRunner = "com.sandbox.composesandbox.HiltTestRunner"
        applicationId = "com.sandbox.composesandbox"
        minSdk = 21
        targetSdk = 30
        versionCode = 1
        versionName = "1.0"
    }

    buildTypes {
        debug { 
            isMinifyEnabled = false
            proguardFiles(getDefaultProguardFile("proguard-android-optimize.txt"), "proguard-rules.pro")
        }
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_1_8
        targetCompatibility = JavaVersion.VERSION_1_8
    }
    kotlinOptions {
        jvmTarget = "1.8"
    }
    buildFeatures {
        compose = true
    }

    composeOptions {
        kotlinCompilerExtensionVersion = "1.0.5"
    }
    packagingOptions {
        resources {
            excludes.apply {
                add("META-INF/AL2.0")
                add("META-INF/LGPL2.1")
            }
        }
    }
}



dependencies {
    implementation(AndroidX.core.ktx)
    implementation(AndroidX.appCompat)
    implementation(Google.android.material)
    implementation(AndroidX.compose.compiler)
    implementation(AndroidX.compose.ui)
    implementation(AndroidX.compose.material)
    implementation(AndroidX.compose.ui.tooling)
    testImplementation(AndroidX.compose.ui.test)
    testImplementation(AndroidX.compose.ui.testJunit4)
    testImplementation(AndroidX.compose.ui.testManifest)
    androidTestImplementation(AndroidX.compose.ui.test)
    androidTestImplementation(AndroidX.compose.ui.testJunit4)
    androidTestImplementation(AndroidX.compose.ui.testManifest)
    implementation(AndroidX.navigation.compose)
    implementation(AndroidX.activity.compose)
    implementation(AndroidX.lifecycle.runtimeKtx)

    implementation(AndroidX.hilt.navigationCompose)

    implementation(Google.dagger.hilt.android)
    kapt(Google.dagger.hilt.compiler)

    // For instrumentation tests
    androidTestImplementation(Google.dagger.hilt.android.testing)
    kaptAndroidTest(Google.dagger.hilt.compiler)

    // For local unit tests
    testImplementation(Google.dagger.hilt.android.testing)
    kaptTest(Google.dagger.hilt.compiler)

    testImplementation(Testing.junit4)
    androidTestImplementation(AndroidX.test.ext.junit)
    androidTestImplementation(AndroidX.test.espresso.core)
}

kapt {
    correctErrorTypes = true
}