package com.sandbox.composesandbox

import android.net.Uri
import android.os.Bundle
import androidx.activity.compose.setContent
import androidx.appcompat.app.AppCompatActivity
import androidx.compose.foundation.layout.Column
import androidx.compose.material.Button
import androidx.compose.material.Text
import androidx.compose.ui.graphics.Color
import androidx.navigation.NavType
import androidx.navigation.compose.NavHost
import androidx.navigation.compose.composable
import androidx.navigation.compose.rememberNavController
import androidx.navigation.navArgument
import dagger.hilt.android.AndroidEntryPoint

@AndroidEntryPoint
class MainActivity : AppCompatActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContent {
            val navController = rememberNavController()
            NavHost(
                navController = navController,
                startDestination = "start",
                route = "nav_host",
            ) {
                composable("start") {
                    Column {
                        Text("Start")
                        Button(
                            onClick = {
                                // I want to display %555, literally
                                navController.navigate(
                                    "sample?arg1=${Uri.encode("%555")}"
                                )
                            }
                        ) {
                            Text("Click to Display '%555'")
                        }
                    }
                }
                composable(
                    "sample?arg1={arg1}",
                    arguments = listOf(
                        navArgument("arg1") {
                            type = NavType.StringType
                            nullable = true
                            defaultValue =null
                        }
                    ),
                ) { navBackStackEntry ->
                    val argValue = navBackStackEntry.arguments?.get("arg1").toString()
                    Text(
                        text = "%555 == $argValue ? (${argValue == "%555"})",
                        color = Color.Red
                    )
                }
            }
        }
    }
}
