package com.random.textfieldcrash

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.compose.foundation.background
import androidx.compose.foundation.border
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.text.BasicTextField
import androidx.compose.material.Button
import androidx.compose.material.MaterialTheme
import androidx.compose.material.Surface
import androidx.compose.material.Text
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp
import com.random.textfieldcrash.ui.theme.TextfieldcrashTheme

class MainActivity : ComponentActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContent {
            TextfieldcrashTheme {
                Surface(
                    modifier = Modifier.fillMaxSize(),
                    color = Color.Black,

                    ) {
                    var text by remember { mutableStateOf("") }
                    var buttonPressed by remember { mutableStateOf(false) }

                    Column(
                        modifier = Modifier.fillMaxWidth(),
                        verticalArrangement = Arrangement.Center
                    ) {
                        BasicTextField(
                            value = text,
                            onValueChange = { text = it },
                            modifier = Modifier
                                .fillMaxWidth()
                                .height(height = 40.dp)
                                .background(color = MaterialTheme.colors.surface)
                                .then(
                                    if (buttonPressed) Modifier.border(
                                        width = 3.dp,
                                        color = Color.Blue
                                    ) else Modifier
                                )
                        )
                        Button(
                            onClick = {
                                text = ""
                                buttonPressed = !buttonPressed
                            },
                            modifier = Modifier
                                .background(color = Color.Black)
                                .align(alignment = Alignment.CenterHorizontally)
                        ) {
                            Text(text = "Button")
                        }
                    }
                }
            }
        }
    }
}