package com.ravi.navigationTest

import android.net.Uri
import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.compose.animation.ExitTransition
import androidx.compose.animation.ExperimentalAnimationApi
import androidx.compose.animation.core.tween
import androidx.compose.animation.fadeIn
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.material.Button
import androidx.compose.material.MaterialTheme
import androidx.compose.material.Surface
import androidx.compose.material.Text
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.sp
import androidx.navigation.NavType
import androidx.navigation.navArgument
import com.google.accompanist.navigation.animation.AnimatedNavHost
import com.google.accompanist.navigation.animation.composable
import com.google.accompanist.navigation.animation.rememberAnimatedNavController
import com.ravi.navigationTest.ui.theme.NavigationTestTheme

class MainActivity : ComponentActivity() {

    @OptIn(ExperimentalAnimationApi::class)
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContent {
            NavigationTestTheme {
                Surface(
                    modifier = Modifier.fillMaxSize(),
                    color = MaterialTheme.colors.background
                ) {
                    val navController = rememberAnimatedNavController()
                    AnimatedNavHost(navController, startDestination = "Blue") {
                        composable("Blue") {
                            Column(
                                modifier = Modifier
                                    .fillMaxSize()
                                    .background(Color.Blue),
                                verticalArrangement = Arrangement.Center,
                                horizontalAlignment = Alignment.CenterHorizontally
                            ) {
                                Text(text = "Blue")
                                Button(onClick = {
                                    val caption =
                                        "FirstLine\nSecondLine" // remove \n to avoid crash
                                    navController.navigate("profile?caption=${Uri.encode(caption)}")
                                }) {
                                    Text(text = "Profile")
                                }
                            }
                        }
                        composable(
                            "profile?caption={caption}",
                            arguments = listOf(navArgument("caption") {
                                type = NavType.StringType
                                nullable = true
                            })
                        ) {
                            val caption = it.arguments?.getString("caption")
                            LazyColumn(
                                modifier = Modifier
                                    .fillMaxSize()
                                    .background(Color.Magenta)
                            ) {
                                item {
                                    Text(
                                        "Profile",
                                        modifier = Modifier
                                            .fillMaxWidth()
                                            .animateEnterExit(
                                                enter = fadeIn(
                                                    animationSpec = tween(
                                                        250,
                                                        delayMillis = 450
                                                    )
                                                ),
                                                exit = ExitTransition.None
                                            ),
                                        color = Color.White,
                                        fontSize = 80.sp,
                                        textAlign = TextAlign.Center
                                    )
                                }
                                item {
                                    Text(
                                        caption ?: "",
                                        modifier = Modifier
                                            .fillMaxWidth()
                                            .animateEnterExit(
                                                enter = fadeIn(
                                                    animationSpec = tween(
                                                        250,
                                                        delayMillis = 450
                                                    )
                                                ),
                                                exit = ExitTransition.None
                                            ),
                                        color = Color.White,
                                        fontSize = 80.sp,
                                        textAlign = TextAlign.Center
                                    )
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
