//
//  ViewController.swift
//  GoogleMapsView
//
//  Created by Matt Czech on 2/17/22.
//

import GoogleMaps
import UIKit

class ViewController: UIViewController {

    let mapView = GMSMapView()

    override func viewDidLoad() {
        super.viewDidLoad()

        let seattleButton = UIButton(type: .system)
        seattleButton.setTitle("Move to Seattle", for: .normal)
        seattleButton.addTarget(self, action: #selector(moveToSeattle), for: .touchUpInside)

        let minneapolisButton = UIButton(type: .system)
        minneapolisButton.setTitle("Move to Minneapolis", for: .normal)
        minneapolisButton.addTarget(self, action: #selector(moveToMinneapolis), for: .touchUpInside)

        let stackView = UIStackView(arrangedSubviews: [seattleButton, minneapolisButton])
        stackView.alignment = .center
        stackView.axis = .vertical
        stackView.spacing = 16
        stackView.translatesAutoresizingMaskIntoConstraints = false

        mapView.delegate = self
        mapView.translatesAutoresizingMaskIntoConstraints = false

        view.addSubview(stackView)
        view.addSubview(mapView)

        NSLayoutConstraint.activate([
            stackView.topAnchor.constraint(equalTo: view.safeAreaLayoutGuide.topAnchor, constant: 16),
            stackView.leadingAnchor.constraint(equalTo: view.safeAreaLayoutGuide.leadingAnchor),
            stackView.trailingAnchor.constraint(equalTo: view.safeAreaLayoutGuide.trailingAnchor),

            mapView.leadingAnchor.constraint(equalTo: view.safeAreaLayoutGuide.leadingAnchor),
            mapView.trailingAnchor.constraint(equalTo: view.safeAreaLayoutGuide.trailingAnchor),
            mapView.bottomAnchor.constraint(equalTo: view.safeAreaLayoutGuide.bottomAnchor),
            mapView.widthAnchor.constraint(equalTo: mapView.heightAnchor),
        ])
    }

    @objc func moveToSeattle() {
        animateMap(to: GMSCameraPosition(target: .seattle, zoom: 15))

    }

    @objc func moveToMinneapolis() {
        animateMap(to: GMSCameraPosition(target: .minneapolis, zoom: 10))
    }

    func animateMap(to position: GMSCameraPosition) {
        print("mapView animateToPosition \(position.target) \(position.zoom)")
        mapView.animate(to: position)
    }
}

extension ViewController: GMSMapViewDelegate {
    func mapView(_ mapView: GMSMapView, didChange position: GMSCameraPosition) {
        print("mapView didChangePosition \(position.target) \(position.zoom)")
    }

    func mapView(_ mapView: GMSMapView, idleAt position: GMSCameraPosition) {
        print("mapView idleAtPosition \(position.target) \(position.zoom)")
    }
}

extension CLLocationCoordinate2D {
    static let minneapolis = CLLocationCoordinate2D(latitude: 44.9778, longitude: -93.2650)
    static let seattle = CLLocationCoordinate2D(latitude: 47.6062, longitude: -122.3320)
}

