# Sample project demonstrating `mapView(_:idleAt:)` called before map reaches final position when animating camera position

When making an animated change to the camera position, the `GMSMapViewDelegate` method `mapView(_:idleAt:)` is called before the map idles at the final position. When `mapView(_:idleAt:)` is called, the position that it reports is not the same as the position that the map is being animated to.

Changing the camera position without animation correctly reports the final position when `mapView(_:idleAt:)` is called.

Expected behavior:

`GMSMapViewDelegate.mapView(_:idleAt:)` should be called once the map reaches its final position after the animation completes, and should contain the same position passed into `GMSMapView.animate(to: <GMSCameraPosition>)`.

What steps will reproduce the problem?

1. Call `mapView.animate(to: <GMSCameraPosition>)`
2. Observe the timing of and the position that is passed into `GMSMapViewDelegate.mapView(_:idleAt:)`.

If I print when the delegate methods are called, I see that idleAt gets called prior to the final didChangePosition delegate call and does not contain the position that was passed into the animateToCameraPosition call. The final didChangePosition call does contain the position that I'm animating to, but I need to know the final position when the map idles.

Here's the camera position I want to animate to:

    mapView.animate(to: GMSCameraPosition(latitude: 44.9778, longitude: -93.2650, zoom: 10))

Log:

    mapView animateToPosition CLLocationCoordinate2D(latitude: 44.9778, longitude: -93.265) 10.0
    mapView didChangePosition CLLocationCoordinate2D(latitude: 50.58661030778135, longitude: -10.560035593807697) 4.573082
    mapView didChangePosition CLLocationCoordinate2D(latitude: 49.72720401661033, longitude: -23.232449926435944) 5.404618
    mapView didChangePosition CLLocationCoordinate2D(latitude: 48.758097148636786, longitude: -37.522459253668785) 6.342297
    mapView didChangePosition CLLocationCoordinate2D(latitude: 48.080882050343185, longitude: -47.50836364924908) 6.99755
    mapView didChangePosition CLLocationCoordinate2D(latitude: 47.27439480059722, longitude: -59.40045800060034) 7.777883
    mapView didChangePosition CLLocationCoordinate2D(latitude: 46.43944882346799, longitude: -71.71219065785407) 8.5857525
    mapView didChangePosition CLLocationCoordinate2D(latitude: 45.610743222534914, longitude: -83.93190812319517) 9.387583
    mapView idleAtPosition CLLocationCoordinate2D(latitude: 45.610743222534914, longitude: -83.93190812319517) 9.387583
    mapView didChangePosition CLLocationCoordinate2D(latitude: 44.97779999772054, longitude: -93.26500006020068) 10.0

Tested with:
- Google Maps iOS SDK 6.0.1
- Xcode 13.2.1
- iOS 15.2.1

