/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.Keep;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.utils.BooleanUtils;
import com.android.tools.r8.utils.Reporter;

@Keep
public class AssertionsConfiguration {
    private final AssertionTransformation transformation;
    private final MethodReference assertionHandler;
    private final AssertionTransformationScope scope;
    private final String value;

    AssertionsConfiguration(AssertionTransformation transformation, MethodReference assertionHandler, AssertionTransformationScope scope, String value) {
        this.transformation = transformation;
        this.assertionHandler = assertionHandler;
        this.scope = scope;
        this.value = value;
        assert (BooleanUtils.xor(transformation != null, assertionHandler != null));
    }

    static Builder builder(Reporter reporter) {
        return new Builder(reporter);
    }

    public boolean isCompileTimeEnabled() {
        return this.transformation == AssertionTransformation.ENABLE;
    }

    public boolean isCompileTimeDisabled() {
        return this.transformation == AssertionTransformation.DISABLE;
    }

    public boolean isPassthrough() {
        return this.transformation == AssertionTransformation.PASSTHROUGH;
    }

    public boolean isAssertionHandler() {
        return this.assertionHandler != null;
    }

    @Deprecated
    public AssertionTransformation getTransformation() {
        return this.transformation;
    }

    public MethodReference getAssertionHandler() {
        return this.assertionHandler;
    }

    public AssertionTransformationScope getScope() {
        return this.scope;
    }

    public String getValue() {
        return this.value;
    }

    @Keep
    public static class Builder {
        Reporter reporter;
        private AssertionTransformation transformation;
        private MethodReference assertionHandler;
        private AssertionTransformationScope scope;
        private String value;

        private Builder(Reporter reporter) {
            this.reporter = reporter;
        }

        public static AssertionsConfiguration compileTimeEnableAllAssertions(Builder builder) {
            return builder.setCompileTimeEnable().setScopeAll().build();
        }

        @Deprecated
        public static AssertionsConfiguration enableAllAssertions(Builder builder) {
            return Builder.compileTimeEnableAllAssertions(builder);
        }

        public static AssertionsConfiguration compileTimeDisableAllAssertions(Builder builder) {
            return builder.setCompileTimeDisable().setScopeAll().build();
        }

        @Deprecated
        public static AssertionsConfiguration disableAllAssertions(Builder builder) {
            return Builder.compileTimeDisableAllAssertions(builder);
        }

        public static AssertionsConfiguration passthroughAllAssertions(Builder builder) {
            return builder.setPassthrough().setScopeAll().build();
        }

        @Deprecated
        public Builder setTransformation(AssertionTransformation transformation) {
            this.transformation = transformation;
            this.assertionHandler = null;
            return this;
        }

        public Builder setCompileTimeEnable() {
            this.setTransformation(AssertionTransformation.ENABLE);
            return this;
        }

        @Deprecated
        public Builder setEnable() {
            this.setTransformation(AssertionTransformation.ENABLE);
            return this;
        }

        public Builder setCompileTimeDisable() {
            this.setTransformation(AssertionTransformation.DISABLE);
            return this;
        }

        @Deprecated
        public Builder setDisable() {
            this.setTransformation(AssertionTransformation.DISABLE);
            return this;
        }

        public Builder setPassthrough() {
            this.setTransformation(AssertionTransformation.PASSTHROUGH);
            return this;
        }

        public Builder setAssertionHandler(MethodReference assertionHandler) {
            this.transformation = null;
            this.assertionHandler = assertionHandler;
            return this;
        }

        public Builder setScopeAll() {
            this.scope = AssertionTransformationScope.ALL;
            this.value = null;
            return this;
        }

        public Builder setScopePackage(String packageName) {
            this.scope = AssertionTransformationScope.PACKAGE;
            this.value = packageName;
            return this;
        }

        public Builder setScopeClass(String className) {
            this.scope = AssertionTransformationScope.CLASS;
            this.value = className;
            return this;
        }

        public AssertionsConfiguration build() {
            if (this.transformation == null && this.assertionHandler == null) {
                this.reporter.error("No transformation or assertion handler specified for building AssertionConfiguration");
            }
            if (this.scope == null) {
                this.reporter.error("No scope specified for building AssertionConfiguration");
            }
            if (this.scope == AssertionTransformationScope.PACKAGE && this.value == null) {
                this.reporter.error("No package name specified for building AssertionConfiguration");
            }
            if (this.scope == AssertionTransformationScope.CLASS && this.value == null) {
                this.reporter.error("No class name specified for building AssertionConfiguration");
            }
            return new AssertionsConfiguration(this.transformation, this.assertionHandler, this.scope, this.value);
        }
    }

    public static enum AssertionTransformationScope {
        ALL,
        PACKAGE,
        CLASS;

    }

    @Deprecated
    @Keep
    public static enum AssertionTransformation {
        ENABLE,
        DISABLE,
        PASSTHROUGH;

    }
}

