/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.ByteDataView;
import com.android.tools.r8.DataDirectoryResource;
import com.android.tools.r8.DataEntryResource;
import com.android.tools.r8.DataResourceConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.InternalProgramOutputPathConsumer;
import com.android.tools.r8.Keep;
import com.android.tools.r8.KeepForSubclassing;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.io.Closer;
import com.android.tools.r8.utils.ArchiveBuilder;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.DirectoryBuilder;
import com.android.tools.r8.utils.OutputBuilder;
import com.android.tools.r8.utils.ZipUtils;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipOutputStream;

@KeepForSubclassing
public interface ClassFileConsumer
extends ProgramConsumer {
    public static ClassFileConsumer emptyConsumer() {
        return ForwardingConsumer.EMPTY_CONSUMER;
    }

    public void accept(ByteDataView var1, String var2, DiagnosticsHandler var3);

    @Keep
    public static class DirectoryConsumer
    extends ForwardingConsumer
    implements InternalProgramOutputPathConsumer {
        private final OutputBuilder outputBuilder;
        protected final boolean consumeDataResouces;

        public DirectoryConsumer(Path directory) {
            this(directory, null, false);
        }

        public DirectoryConsumer(Path directory, boolean consumeDataResouces) {
            this(directory, null, consumeDataResouces);
        }

        public DirectoryConsumer(Path directory, ClassFileConsumer consumer) {
            this(directory, consumer, false);
        }

        public DirectoryConsumer(Path directory, ClassFileConsumer consumer, boolean consumeDataResouces) {
            super(consumer);
            this.outputBuilder = new DirectoryBuilder(directory);
            this.consumeDataResouces = consumeDataResouces;
        }

        @Override
        public DataResourceConsumer getDataResourceConsumer() {
            return this.consumeDataResouces ? this : null;
        }

        @Override
        public void accept(ByteDataView data2, String descriptor, DiagnosticsHandler handler) {
            super.accept(data2, descriptor, handler);
            this.outputBuilder.addFile(DescriptorUtils.getClassFileName(descriptor), data2, handler);
        }

        @Override
        public void accept(DataDirectoryResource directory, DiagnosticsHandler handler) {
            this.outputBuilder.addDirectory(directory.getName(), handler);
        }

        @Override
        public void accept(DataEntryResource file, DiagnosticsHandler handler) {
            this.outputBuilder.addFile(file.getName(), file, handler);
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            super.finished(handler);
        }

        @Override
        public Path internalGetOutputPath() {
            return this.outputBuilder.getPath();
        }
    }

    @Keep
    public static class ArchiveConsumer
    extends ForwardingConsumer
    implements DataResourceConsumer,
    InternalProgramOutputPathConsumer {
        private final OutputBuilder outputBuilder;
        protected final boolean consumeDataResources;

        public ArchiveConsumer(Path archive) {
            this(archive, null, false);
        }

        public ArchiveConsumer(Path archive, boolean consumeDataResouces) {
            this(archive, null, consumeDataResouces);
        }

        public ArchiveConsumer(Path archive, ClassFileConsumer consumer) {
            this(archive, consumer, false);
        }

        public ArchiveConsumer(Path archive, ClassFileConsumer consumer, boolean consumeDataResouces) {
            super(consumer);
            this.outputBuilder = new ArchiveBuilder(archive);
            this.consumeDataResources = consumeDataResouces;
            this.outputBuilder.open();
            if (this.getDataResourceConsumer() != null) {
                this.outputBuilder.open();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static void writeResources(Path archive, List<ProgramResource> resources, Set<DataEntryResource> dataResources) throws IOException, ResourceException {
            OpenOption[] options = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
            Closer closer = Closer.create();
            Throwable throwable = null;
            try {
                ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(archive, options)));
                Throwable throwable2 = null;
                try {
                    ZipUtils.writeResourcesToZip(resources, dataResources, closer, out);
                }
                catch (Throwable throwable3) {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        ArchiveConsumer.$closeResource(throwable2, out);
                        throw throwable4;
                    }
                }
                ArchiveConsumer.$closeResource(throwable2, out);
                if (closer == null) return;
            }
            catch (Throwable throwable5) {
                try {
                    throwable = throwable5;
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    if (closer == null) throw throwable6;
                    ArchiveConsumer.$closeResource(throwable, closer);
                    throw throwable6;
                }
            }
            ArchiveConsumer.$closeResource(throwable, closer);
        }

        private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
            if (x0 != null) {
                try {
                    x1.close();
                }
                catch (Throwable throwable) {
                    x0.addSuppressed(throwable);
                }
            } else {
                x1.close();
            }
        }

        @Override
        public DataResourceConsumer getDataResourceConsumer() {
            return this.consumeDataResources ? this : null;
        }

        @Override
        public void accept(ByteDataView data2, String descriptor, DiagnosticsHandler handler) {
            super.accept(data2, descriptor, handler);
            this.outputBuilder.addFile(DescriptorUtils.getClassFileName(descriptor), data2, handler);
        }

        @Override
        public void accept(DataDirectoryResource directory, DiagnosticsHandler handler) {
            this.outputBuilder.addDirectory(directory.getName(), handler);
        }

        @Override
        public void accept(DataEntryResource file, DiagnosticsHandler handler) {
            this.outputBuilder.addFile(file.getName(), file, handler);
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            super.finished(handler);
            this.outputBuilder.close(handler);
        }

        @Override
        public Path internalGetOutputPath() {
            return this.outputBuilder.getPath();
        }
    }

    @Keep
    public static class ForwardingConsumer
    implements ClassFileConsumer {
        private static final ClassFileConsumer EMPTY_CONSUMER = new ForwardingConsumer(null);
        private final ClassFileConsumer consumer;

        public ForwardingConsumer(ClassFileConsumer consumer) {
            this.consumer = consumer;
        }

        @Override
        public DataResourceConsumer getDataResourceConsumer() {
            return this.consumer != null ? this.consumer.getDataResourceConsumer() : null;
        }

        @Override
        public void accept(ByteDataView data2, String descriptor, DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.accept(data2, descriptor, handler);
            }
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.finished(handler);
            }
        }
    }
}

