/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.AssertionsConfiguration;
import com.android.tools.r8.BaseCompilerCommand;
import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.D8CommandParser;
import com.android.tools.r8.DesugarGraphConsumer;
import com.android.tools.r8.DexFilePerClassFileConsumer;
import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.Keep;
import com.android.tools.r8.MapIdProvider;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.dump.DumpOptions;
import com.android.tools.r8.errors.DexFileOverflowDiagnostic;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.inspector.Inspector;
import com.android.tools.r8.inspector.internal.InspectorImpl;
import com.android.tools.r8.ir.desugar.desugaredlibrary.DesugaredLibrarySpecification;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.shaking.ProguardConfigurationParser;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardConfigurationSource;
import com.android.tools.r8.shaking.ProguardConfigurationSourceFile;
import com.android.tools.r8.shaking.ProguardConfigurationSourceStrings;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.AssertionConfigurationWithDefault;
import com.android.tools.r8.utils.DumpInputFlags;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;

@Keep
public final class D8Command
extends BaseCompilerCommand {
    static final String USAGE_MESSAGE = D8CommandParser.USAGE_MESSAGE;
    private final boolean intermediate;
    private final DesugarGraphConsumer desugarGraphConsumer;
    private final StringConsumer desugaredLibraryKeepRuleConsumer;
    private final DesugaredLibrarySpecification desugaredLibrarySpecification;
    private final String synthesizedClassPrefix;
    private final boolean skipDump;
    private final boolean enableMainDexListCheck;
    private final boolean minimalMainDex;
    private final ImmutableList<ProguardConfigurationRule> mainDexKeepRules;
    private final DexItemFactory factory;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DiagnosticsHandler diagnosticsHandler) {
        return new Builder(diagnosticsHandler);
    }

    static Builder builder(AndroidApp app) {
        return new Builder(app);
    }

    public static Builder parse(String[] args2, Origin origin) {
        return D8CommandParser.parse(args2, origin);
    }

    public static Builder parse(String[] args2, Origin origin, DiagnosticsHandler handler) {
        return D8CommandParser.parse(args2, origin, handler);
    }

    private D8Command(AndroidApp inputApp, CompilationMode mode, ProgramConsumer programConsumer, StringConsumer mainDexListConsumer, int minApiLevel, Reporter diagnosticsHandler, InternalOptions.DesugarState enableDesugaring, boolean intermediate, boolean optimizeMultidexForLinearAlloc, boolean encodeChecksum, BiPredicate<String, Long> dexClassChecksumFilter, DesugarGraphConsumer desugarGraphConsumer, StringConsumer desugaredLibraryKeepRuleConsumer, DesugaredLibrarySpecification desugaredLibrarySpecification, List<AssertionsConfiguration> assertionsConfiguration, List<Consumer<Inspector>> outputInspections, String synthesizedClassPrefix, boolean skipDump, boolean enableMainDexListCheck, boolean minimalMainDex, ImmutableList<ProguardConfigurationRule> mainDexKeepRules, int threadCount, DumpInputFlags dumpInputFlags, MapIdProvider mapIdProvider, DexItemFactory factory) {
        super(inputApp, mode, programConsumer, mainDexListConsumer, minApiLevel, diagnosticsHandler, enableDesugaring, optimizeMultidexForLinearAlloc, encodeChecksum, dexClassChecksumFilter, assertionsConfiguration, outputInspections, threadCount, dumpInputFlags, mapIdProvider, null);
        this.intermediate = intermediate;
        this.desugarGraphConsumer = desugarGraphConsumer;
        this.desugaredLibraryKeepRuleConsumer = desugaredLibraryKeepRuleConsumer;
        this.desugaredLibrarySpecification = desugaredLibrarySpecification;
        this.synthesizedClassPrefix = synthesizedClassPrefix;
        this.skipDump = skipDump;
        this.enableMainDexListCheck = enableMainDexListCheck;
        this.minimalMainDex = minimalMainDex;
        this.mainDexKeepRules = mainDexKeepRules;
        this.factory = factory;
    }

    private D8Command(boolean printHelp, boolean printVersion) {
        super(printHelp, printVersion);
        this.intermediate = false;
        this.desugarGraphConsumer = null;
        this.desugaredLibraryKeepRuleConsumer = null;
        this.desugaredLibrarySpecification = null;
        this.synthesizedClassPrefix = null;
        this.skipDump = false;
        this.enableMainDexListCheck = true;
        this.minimalMainDex = false;
        this.mainDexKeepRules = null;
        this.factory = null;
    }

    private DumpOptions dumpOptions() {
        DumpOptions.Builder builder = DumpOptions.builder(Marker.Tool.D8).readCurrentSystemProperties();
        this.dumpBaseCommandOptions(builder);
        return builder.setIntermediate(this.intermediate).setDesugaredLibraryConfiguration(this.desugaredLibrarySpecification).setMainDexKeepRules(this.mainDexKeepRules).build();
    }

    @Override
    InternalOptions getInternalOptions() {
        InternalOptions internal = new InternalOptions(this.factory, this.getReporter());
        assert (!internal.debug);
        internal.debug = this.getMode() == CompilationMode.DEBUG;
        internal.programConsumer = this.getProgramConsumer();
        if (internal.isGeneratingClassFiles()) {
            internal.cfToCfDesugar = true;
            assert (internal.enableSwitchRewriting);
            internal.enableSwitchRewriting = false;
            assert (internal.enableStringSwitchConversion);
            internal.enableStringSwitchConversion = false;
        } else assert (!internal.desugarSpecificOptions().allowAllDesugaredInput || this.getDesugarState() == InternalOptions.DesugarState.OFF);
        internal.mainDexListConsumer = this.getMainDexListConsumer();
        internal.minimalMainDex = internal.debug || this.minimalMainDex;
        internal.enableMainDexListCheck = this.enableMainDexListCheck;
        internal.setMinApiLevel(AndroidApiLevel.getAndroidApiLevel(this.getMinApiLevel()));
        internal.intermediate = this.intermediate;
        internal.retainCompileTimeAnnotations = this.intermediate;
        internal.desugarGraphConsumer = this.desugarGraphConsumer;
        internal.mainDexKeepRules = this.mainDexKeepRules;
        internal.lineNumberOptimization = InternalOptions.LineNumberOptimization.OFF;
        assert (!internal.isShrinking());
        assert (!internal.isMinifying());
        assert (!internal.passthroughDexCode);
        internal.passthroughDexCode = true;
        assert (internal.neverMergePrefixes.contains("j$."));
        assert (!internal.inlinerOptions().enableInlining);
        assert (!internal.enableClassInlining);
        assert (!internal.enableVerticalClassMerging);
        assert (!internal.enableEnumValueOptimization);
        assert (!internal.outline.enabled);
        assert (!internal.enableTreeShakingOfLibraryMethodOverrides);
        internal.desugarState = this.getDesugarState();
        internal.encodeChecksums = this.getIncludeClassesChecksum();
        internal.dexClassChecksumFilter = this.getDexClassChecksumFilter();
        internal.enableInheritanceClassInDexDistributor = this.isOptimizeMultidexForLinearAlloc();
        internal.setDesugaredLibrarySpecification(this.desugaredLibrarySpecification);
        internal.synthesizedClassPrefix = this.synthesizedClassPrefix;
        internal.desugaredLibraryKeepRuleConsumer = this.desugaredLibraryKeepRuleConsumer;
        assert (internal.assertionsConfiguration == null);
        internal.assertionsConfiguration = new AssertionConfigurationWithDefault(AssertionsConfiguration.builder(this.getReporter()).setTransformation(AssertionsConfiguration.AssertionTransformation.DISABLE).setScopeAll().build(), this.getAssertionsConfiguration());
        internal.outputInspections = InspectorImpl.wrapInspections(this.getOutputInspections());
        assert (internal.threadCount == -1);
        internal.threadCount = this.getThreadCount();
        internal.disableGlobalOptimizations();
        InternalOptions.HorizontalClassMergerOptions horizontalClassMergerOptions = internal.horizontalClassMergerOptions();
        if (internal.isGeneratingDex()) {
            horizontalClassMergerOptions.setRestrictToSynthetics();
        } else {
            assert (internal.isGeneratingClassFiles());
            horizontalClassMergerOptions.disable();
        }
        internal.setDumpInputFlags(this.getDumpInputFlags(), this.skipDump);
        internal.dumpOptions = this.dumpOptions();
        return internal;
    }

    @Keep
    public static class Builder
    extends BaseCompilerCommand.Builder<D8Command, Builder> {
        private boolean intermediate = false;
        private DesugarGraphConsumer desugarGraphConsumer = null;
        private StringConsumer desugaredLibraryKeepRuleConsumer = null;
        private String synthesizedClassPrefix = "";
        private boolean enableMainDexListCheck = true;
        private boolean minimalMainDex = false;
        private boolean skipDump = false;
        private final List<ProguardConfigurationSource> mainDexRules = new ArrayList<ProguardConfigurationSource>();

        private Builder() {
            this(new DefaultD8DiagnosticsHandler());
        }

        private Builder(DiagnosticsHandler diagnosticsHandler) {
            super(diagnosticsHandler);
        }

        private Builder(AndroidApp app) {
            super(app);
        }

        @Override
        public Builder addDexProgramData(byte[] data2, Origin origin) {
            this.guard(() -> this.getAppBuilder().addDexProgramData(data2, origin));
            return this.self();
        }

        @Override
        public Builder addClasspathFiles(Path ... files) {
            return (Builder)super.addClasspathFiles(files);
        }

        @Override
        public Builder addClasspathFiles(Collection<Path> files) {
            return (Builder)super.addClasspathFiles(files);
        }

        @Override
        public Builder addClasspathResourceProvider(ClassFileResourceProvider provider) {
            return (Builder)super.addClasspathResourceProvider(provider);
        }

        public Builder setProguardInputMapFile(Path proguardInputMap) {
            this.getAppBuilder().setProguardMapInputData(proguardInputMap);
            return this.self();
        }

        public Builder setIntermediate(boolean value) {
            this.intermediate = value;
            return this.self();
        }

        public Builder setDesugaredLibraryKeepRuleConsumer(StringConsumer keepRuleConsumer) {
            this.desugaredLibraryKeepRuleConsumer = keepRuleConsumer;
            return this.self();
        }

        public DesugarGraphConsumer getDesugarGraphConsumer() {
            return this.desugarGraphConsumer;
        }

        public Builder setDesugarGraphConsumer(DesugarGraphConsumer desugarGraphConsumer) {
            this.desugarGraphConsumer = desugarGraphConsumer;
            return this.self();
        }

        Builder skipDump() {
            this.skipDump = true;
            return this.self();
        }

        @Override
        Builder self() {
            return this;
        }

        @Override
        CompilationMode defaultCompilationMode() {
            return CompilationMode.DEBUG;
        }

        Builder setSynthesizedClassesPrefix(String prefix) {
            this.synthesizedClassPrefix = prefix;
            return this.self();
        }

        @Deprecated
        Builder setEnableMainDexListCheck(boolean value) {
            this.enableMainDexListCheck = value;
            return this.self();
        }

        @Deprecated
        Builder setMinimalMainDex(boolean value) {
            this.minimalMainDex = value;
            return this.self();
        }

        public Builder addMainDexRulesFiles(Path ... paths) {
            return this.addMainDexRulesFiles(Arrays.asList(paths));
        }

        public Builder addMainDexRulesFiles(Collection<Path> paths) {
            this.guard(() -> paths.forEach(p -> this.mainDexRules.add(new ProguardConfigurationSourceFile((Path)p))));
            return this.self();
        }

        public Builder addMainDexRules(List<String> lines, Origin origin) {
            this.guard(() -> this.mainDexRules.add(new ProguardConfigurationSourceStrings(lines, Paths.get(".", new String[0]), origin)));
            return this.self();
        }

        @Override
        void validate() {
            if (this.isPrintHelp()) {
                return;
            }
            Reporter reporter = this.getReporter();
            if (this.getAppBuilder().hasMainDexList()) {
                if (this.intermediate) {
                    reporter.error("Option --main-dex-list cannot be used with --intermediate");
                }
                if (this.getProgramConsumer() instanceof DexFilePerClassFileConsumer) {
                    reporter.error("Option --main-dex-list cannot be used with --file-per-class");
                }
            }
            if (!this.mainDexRules.isEmpty()) {
                if (this.intermediate) {
                    reporter.error("Option --main-dex-rules cannot be used with --intermediate");
                }
                if (this.getProgramConsumer() instanceof DexFilePerClassFileConsumer) {
                    reporter.error("Option --main-dex-rules cannot be used with --file-per-class");
                }
            }
            if (this.getMainDexListConsumer() != null && this.mainDexRules.isEmpty() && !this.getAppBuilder().hasMainDexList()) {
                reporter.error("Option --main-dex-list-output requires --main-dex-rules and/or --main-dex-list");
            }
            if (this.getMinApiLevel() >= AndroidApiLevel.L.getLevel() && (this.getMainDexListConsumer() != null || this.getAppBuilder().hasMainDexList())) {
                reporter.error("D8 does not support main-dex inputs and outputs when compiling to API level " + AndroidApiLevel.L.getLevel() + " and above");
            }
            if (this.hasDesugaredLibraryConfiguration() && this.getDisableDesugaring()) {
                reporter.error("Using desugared library configuration requires desugaring to be enabled");
            }
            super.validate();
        }

        @Override
        D8Command makeCommand() {
            if (this.isPrintHelp() || this.isPrintVersion()) {
                return new D8Command(this.isPrintHelp(), this.isPrintVersion());
            }
            this.intermediate |= this.getProgramConsumer() instanceof DexFilePerClassFileConsumer;
            DexItemFactory factory = new DexItemFactory();
            DesugaredLibrarySpecification desugaredLibrarySpecification = this.getDesugaredLibraryConfiguration(factory, false);
            ImmutableList<ProguardConfigurationRule> mainDexKeepRules = ProguardConfigurationParser.parse(this.mainDexRules, factory, this.getReporter());
            return new D8Command(this.getAppBuilder().build(), this.getMode(), this.getProgramConsumer(), this.getMainDexListConsumer(), this.getMinApiLevel(), this.getReporter(), this.getDesugaringState(), this.intermediate, this.isOptimizeMultidexForLinearAlloc(), this.getIncludeClassesChecksum(), this.getDexClassChecksumFilter(), this.getDesugarGraphConsumer(), this.desugaredLibraryKeepRuleConsumer, desugaredLibrarySpecification, this.getAssertionsConfiguration(), this.getOutputInspections(), this.synthesizedClassPrefix, this.skipDump, this.enableMainDexListCheck, this.minimalMainDex, mainDexKeepRules, this.getThreadCount(), this.getDumpInputFlags(), this.getMapIdProvider(), factory);
        }
    }

    private static class DefaultD8DiagnosticsHandler
    implements DiagnosticsHandler {
        private DefaultD8DiagnosticsHandler() {
        }

        @Override
        public void error(Diagnostic error) {
            DexFileOverflowDiagnostic overflowDiagnostic;
            if (error instanceof DexFileOverflowDiagnostic && !(overflowDiagnostic = (DexFileOverflowDiagnostic)error).hasMainDexSpecification()) {
                DiagnosticsHandler.super.error(new StringDiagnostic(overflowDiagnostic.getDiagnosticMessage() + ". Try supplying a main-dex list"));
                return;
            }
            DiagnosticsHandler.super.error(error);
        }
    }
}

