/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.ByteBufferProvider;
import com.android.tools.r8.ByteDataView;
import com.android.tools.r8.DataDirectoryResource;
import com.android.tools.r8.DataEntryResource;
import com.android.tools.r8.DataResourceConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.InternalProgramOutputPathConsumer;
import com.android.tools.r8.Keep;
import com.android.tools.r8.KeepForSubclassing;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.com.google.common.io.Closer;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.ArchiveBuilder;
import com.android.tools.r8.utils.DexUtils;
import com.android.tools.r8.utils.DirectoryBuilder;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.OutputBuilder;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ZipUtils;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipOutputStream;

@KeepForSubclassing
public interface DexIndexedConsumer
extends ProgramConsumer,
ByteBufferProvider {
    public static DexIndexedConsumer emptyConsumer() {
        return ForwardingConsumer.EMPTY_CONSUMER;
    }

    default public void accept(int fileIndex, ByteDataView data2, Set<String> descriptors, DiagnosticsHandler handler) {
        this.accept(fileIndex, data2.copyByteData(), descriptors, handler);
    }

    @Deprecated
    default public void accept(int fileIndex, byte[] data2, Set<String> descriptors, DiagnosticsHandler handler) {
        handler.error(new StringDiagnostic("Deprecated use of DexIndexedConsumer::accept(..., byte[], ...)"));
    }

    @Keep
    public static class DirectoryConsumer
    extends ForwardingConsumer
    implements DataResourceConsumer,
    InternalProgramOutputPathConsumer {
        private final Path directory;
        private boolean preparedDirectory = false;
        private final OutputBuilder outputBuilder;
        protected final boolean consumeDataResouces;

        public DirectoryConsumer(Path directory) {
            this(directory, null, false);
        }

        public DirectoryConsumer(Path directory, boolean consumeDataResouces) {
            this(directory, null, consumeDataResouces);
        }

        public DirectoryConsumer(Path directory, DexIndexedConsumer consumer) {
            this(directory, consumer, false);
        }

        public DirectoryConsumer(Path directory, DexIndexedConsumer consumer, boolean consumeDataResouces) {
            super(consumer);
            this.directory = directory;
            this.outputBuilder = new DirectoryBuilder(directory);
            this.consumeDataResouces = consumeDataResouces;
        }

        private synchronized void prepareDirectory() throws IOException {
            if (this.preparedDirectory) {
                return;
            }
            this.preparedDirectory = true;
            DirectoryConsumer.deleteClassesDexFiles(this.directory);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static void deleteClassesDexFiles(Path directory) throws IOException {
            Stream<Path> filesInDir = Files.list(directory);
            Throwable throwable = null;
            try {
                for (Path path : filesInDir.collect(Collectors.toList())) {
                    if (!FileUtils.isClassesDexFile(path)) continue;
                    Files.delete(path);
                }
                if (filesInDir == null) return;
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (filesInDir == null) throw throwable3;
                    DirectoryConsumer.$closeResource(throwable, filesInDir);
                    throw throwable3;
                }
            }
            DirectoryConsumer.$closeResource(throwable, filesInDir);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static void writeResources(Path directory, List<ProgramResource> resources) throws IOException, ResourceException {
            DirectoryConsumer.deleteClassesDexFiles(directory);
            Closer closer = Closer.create();
            Throwable throwable = null;
            try {
                for (int i = 0; i < resources.size(); ++i) {
                    ProgramResource resource = resources.get(i);
                    Path target = DirectoryConsumer.getTargetDexFile(directory, i);
                    DirectoryConsumer.writeFile(ByteStreams.toByteArray(closer.register(resource.getByteStream())), target);
                }
                if (closer == null) return;
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (closer == null) throw throwable3;
                    DirectoryConsumer.$closeResource(throwable, closer);
                    throw throwable3;
                }
            }
            DirectoryConsumer.$closeResource(throwable, closer);
        }

        private static Path getTargetDexFile(Path directory, int fileIndex) {
            return directory.resolve(DexUtils.getDefaultDexFileName(fileIndex));
        }

        private static void writeFile(byte[] contents, Path target) throws IOException {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            FileUtils.writeToFile(target, null, contents);
        }

        private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
            if (x0 != null) {
                try {
                    x1.close();
                }
                catch (Throwable throwable) {
                    x0.addSuppressed(throwable);
                }
            } else {
                x1.close();
            }
        }

        @Override
        public DataResourceConsumer getDataResourceConsumer() {
            return this.consumeDataResouces ? this : null;
        }

        @Override
        public void accept(int fileIndex, ByteDataView data2, Set<String> descriptors, DiagnosticsHandler handler) {
            super.accept(fileIndex, data2, descriptors, handler);
            try {
                this.prepareDirectory();
            }
            catch (IOException e) {
                handler.error(new ExceptionDiagnostic(e, new PathOrigin(this.directory)));
            }
            this.outputBuilder.addFile(DexUtils.getDefaultDexFileName(fileIndex), data2, handler);
        }

        @Override
        public void accept(DataDirectoryResource directory, DiagnosticsHandler handler) {
            this.outputBuilder.addDirectory(directory.getName(), handler);
        }

        @Override
        public void accept(DataEntryResource file, DiagnosticsHandler handler) {
            this.outputBuilder.addFile(file.getName(), file, handler);
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            super.finished(handler);
            this.outputBuilder.close(handler);
        }

        @Override
        public Path internalGetOutputPath() {
            return this.outputBuilder.getPath();
        }
    }

    @Keep
    public static class ArchiveConsumer
    extends ForwardingConsumer
    implements DataResourceConsumer,
    InternalProgramOutputPathConsumer {
        protected final OutputBuilder outputBuilder;
        protected final boolean consumeDataResources;

        public ArchiveConsumer(Path archive) {
            this(archive, null, false);
        }

        public ArchiveConsumer(Path archive, boolean consumeDataResources) {
            this(archive, null, consumeDataResources);
        }

        public ArchiveConsumer(Path archive, DexIndexedConsumer consumer) {
            this(archive, consumer, false);
        }

        public ArchiveConsumer(Path archive, DexIndexedConsumer consumer, boolean consumeDataResources) {
            super(consumer);
            this.outputBuilder = new ArchiveBuilder(archive);
            this.consumeDataResources = consumeDataResources;
            this.outputBuilder.open();
            if (this.getDataResourceConsumer() != null) {
                this.outputBuilder.open();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static void writeResources(Path archive, List<ProgramResource> resources, Set<DataEntryResource> dataResources) throws IOException, ResourceException {
            OpenOption[] options = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
            Closer closer = Closer.create();
            Throwable throwable = null;
            try {
                ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(archive, options)));
                Throwable throwable2 = null;
                try {
                    byte[] bytes;
                    String entryName;
                    for (int i = 0; i < resources.size(); ++i) {
                        ProgramResource resource = resources.get(i);
                        entryName = DexUtils.getDefaultDexFileName(i);
                        bytes = ByteStreams.toByteArray(closer.register(resource.getByteStream()));
                        ZipUtils.writeToZipStream(out, entryName, bytes, 0);
                    }
                    for (DataEntryResource dataResource : dataResources) {
                        entryName = dataResource.getName();
                        bytes = ByteStreams.toByteArray(closer.register(dataResource.getByteStream()));
                        ZipUtils.writeToZipStream(out, entryName, bytes, 0);
                    }
                }
                catch (Throwable throwable3) {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        ArchiveConsumer.$closeResource(throwable2, out);
                        throw throwable4;
                    }
                }
                ArchiveConsumer.$closeResource(throwable2, out);
                if (closer == null) return;
            }
            catch (Throwable throwable5) {
                try {
                    throwable = throwable5;
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    if (closer == null) throw throwable6;
                    ArchiveConsumer.$closeResource(throwable, closer);
                    throw throwable6;
                }
            }
            ArchiveConsumer.$closeResource(throwable, closer);
        }

        private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
            if (x0 != null) {
                try {
                    x1.close();
                }
                catch (Throwable throwable) {
                    x0.addSuppressed(throwable);
                }
            } else {
                x1.close();
            }
        }

        public Origin getOrigin() {
            return this.outputBuilder.getOrigin();
        }

        @Override
        public DataResourceConsumer getDataResourceConsumer() {
            return this.consumeDataResources ? this : null;
        }

        @Override
        public void accept(int fileIndex, ByteDataView data2, Set<String> descriptors, DiagnosticsHandler handler) {
            super.accept(fileIndex, data2, descriptors, handler);
            this.outputBuilder.addIndexedClassFile(fileIndex, DexUtils.getDefaultDexFileName(fileIndex), data2, handler);
        }

        @Override
        public void accept(DataDirectoryResource directory, DiagnosticsHandler handler) {
            this.outputBuilder.addDirectory(directory.getName(), handler);
        }

        @Override
        public void accept(DataEntryResource file, DiagnosticsHandler handler) {
            this.outputBuilder.addFile(file.getName(), file, handler);
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            super.finished(handler);
            this.outputBuilder.close(handler);
        }

        @Override
        public Path internalGetOutputPath() {
            return this.outputBuilder.getPath();
        }
    }

    @Keep
    public static class ForwardingConsumer
    implements DexIndexedConsumer {
        private static final DexIndexedConsumer EMPTY_CONSUMER = new ForwardingConsumer(null);
        private final DexIndexedConsumer consumer;

        public ForwardingConsumer(DexIndexedConsumer consumer) {
            this.consumer = consumer;
        }

        @Override
        public DataResourceConsumer getDataResourceConsumer() {
            return this.consumer != null ? this.consumer.getDataResourceConsumer() : null;
        }

        @Override
        public void accept(int fileIndex, ByteDataView data2, Set<String> descriptors, DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.accept(fileIndex, data2, descriptors, handler);
            }
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.finished(handler);
            }
        }
    }
}

