/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.AndroidAppConsumers;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.InternalOptions;
import java.nio.file.Path;
import java.nio.file.Paths;

public class DexRoundTrip {
    public static void process(D8Command.Builder builder) throws CompilationFailedException {
        builder.setDisableDesugaring(true);
        D8Command command = (D8Command)builder.build();
        InternalOptions options = command.getInternalOptions();
        AndroidApp app = command.getInputApp();
        options.passthroughDexCode = false;
        D8.runForTesting(app, options);
    }

    public static void main(String[] args2) throws CompilationFailedException {
        D8Command.Builder builder = D8Command.builder();
        for (String arg : args2) {
            Path file = Paths.get(arg, new String[0]);
            if (!FileUtils.isDexFile(file)) {
                throw new IllegalArgumentException("Only DEX files are supported as inputs. Invalid file: " + file);
            }
            builder.addProgramFiles(file);
        }
        AndroidAppConsumers consumer = new AndroidAppConsumers();
        builder.setProgramConsumer(consumer.wrapDexIndexedConsumer(null));
        DexRoundTrip.process(builder);
        DexRoundTrip.process((D8Command.Builder)D8Command.builder(consumer.build()).setProgramConsumer(DexIndexedConsumer.emptyConsumer()));
    }
}

