/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.DiagnosticsLevel;
import com.android.tools.r8.Keep;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;
import java.io.PrintStream;

@Keep
public interface DiagnosticsHandler {
    public static void printDiagnosticToStream(Diagnostic diagnostic, String prefix, PrintStream stream) {
        if (diagnostic.getOrigin() != Origin.unknown()) {
            stream.print(prefix + " in " + diagnostic.getOrigin());
            if (diagnostic.getPosition() != Position.UNKNOWN) {
                stream.print(" at " + diagnostic.getPosition().getDescription());
            }
            stream.println(":");
        } else {
            stream.print(prefix + ": ");
        }
        stream.println(diagnostic.getDiagnosticMessage());
    }

    default public void error(Diagnostic error) {
        DiagnosticsHandler.printDiagnosticToStream(error, "Error", System.err);
    }

    default public void warning(Diagnostic warning) {
        DiagnosticsHandler.printDiagnosticToStream(warning, "Warning", System.err);
    }

    default public void info(Diagnostic info) {
        DiagnosticsHandler.printDiagnosticToStream(info, "Info", System.out);
    }

    default public DiagnosticsLevel modifyDiagnosticsLevel(DiagnosticsLevel level, Diagnostic diagnostic) {
        return level;
    }
}

