/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.errors.CompilationError;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

class ExtractMarkerCommand {
    static final String USAGE_MESSAGE = String.join((CharSequence)"\n", ImmutableList.of("Usage: extractmarker [options] <input-files>", " where <input-files> are dex or vdex files", "  --no-other              # Only show information for D8 or R8 processed files.", "  --verbose               # More verbose output.", "  --summary               # Print summary at the end.", "  --csv                   # Output in CSV format.", "  --help                  # Print this message."));
    private final boolean printHelp;
    private final boolean includeOther;
    private final boolean verbose;
    private final boolean summary;
    private final boolean csv;
    private final List<Path> programFiles;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder parse(String[] args2) throws IOException {
        Builder builder = ExtractMarkerCommand.builder();
        ExtractMarkerCommand.parse(args2, builder);
        return builder;
    }

    private static void parse(String[] args2, Builder builder) throws IOException {
        for (int i = 0; i < args2.length; ++i) {
            String arg = args2[i].trim();
            if (arg.length() == 0) continue;
            if (arg.equals("--no-other")) {
                builder.setIncludeOther(false);
                continue;
            }
            if (arg.equals("--verbose")) {
                builder.setVerbose(true);
                continue;
            }
            if (arg.equals("--summary")) {
                builder.setSummary(true);
                continue;
            }
            if (arg.equals("--csv")) {
                builder.setCSV(true);
                continue;
            }
            if (arg.equals("--help")) {
                builder.setPrintHelp(true);
                continue;
            }
            if (arg.startsWith("--")) {
                throw new CompilationError("Unknown option: " + arg);
            }
            builder.addProgramFile(Paths.get(arg, new String[0]));
        }
    }

    private ExtractMarkerCommand(boolean includeOther, boolean verbose, boolean summary, boolean csv, List<Path> programFiles) {
        this.printHelp = false;
        this.includeOther = includeOther;
        this.verbose = verbose;
        this.summary = summary;
        this.csv = csv;
        this.programFiles = programFiles;
    }

    private ExtractMarkerCommand(boolean printHelp) {
        this.printHelp = printHelp;
        this.includeOther = true;
        this.verbose = false;
        this.summary = false;
        this.csv = false;
        this.programFiles = ImmutableList.of();
    }

    public boolean isPrintHelp() {
        return this.printHelp;
    }

    public List<Path> getProgramFiles() {
        return this.programFiles;
    }

    public boolean getIncludeOther() {
        return this.includeOther;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public boolean getSummary() {
        return this.summary;
    }

    public boolean getCSV() {
        return this.csv;
    }

    public static class Builder {
        private boolean printHelp = false;
        private boolean includeOther = true;
        private boolean verbose;
        private boolean summary;
        private boolean csv;
        private final List<Path> programFiles = new ArrayList<Path>();

        public Builder setPrintHelp(boolean printHelp) {
            this.printHelp = printHelp;
            return this;
        }

        public boolean isPrintHelp() {
            return this.printHelp;
        }

        public Builder setIncludeOther(boolean includeOther) {
            this.includeOther = includeOther;
            return this;
        }

        public Builder setVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder setSummary(boolean summary) {
            this.summary = summary;
            return this;
        }

        public Builder setCSV(boolean csv) {
            this.csv = csv;
            return this;
        }

        public Builder addProgramFile(Path programFile) {
            this.programFiles.add(programFile);
            return this;
        }

        public ExtractMarkerCommand build() throws IOException {
            if (this.isPrintHelp()) {
                return new ExtractMarkerCommand(this.isPrintHelp());
            }
            return new ExtractMarkerCommand(this.includeOther, this.verbose, this.summary, this.csv, this.programFiles);
        }
    }
}

