/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.ClassFileConsumer;
import com.android.tools.r8.StringResource;
import com.android.tools.r8.cf.CfVersion;
import com.android.tools.r8.cf.code.CfConstNull;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfThrow;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.graph.FieldAccessFlags;
import com.android.tools.r8.graph.GenericSignature;
import com.android.tools.r8.graph.LazyLoadedDexApplication;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.MethodCollection;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.desugar.desugaredlibrary.DesugaredLibrarySpecification;
import com.android.tools.r8.ir.desugar.desugaredlibrary.DesugaredLibrarySpecificationParser;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.MachineDesugaredLibrarySpecification;
import com.android.tools.r8.jar.CfApplicationWriter;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringUtils;
import com.android.tools.r8.utils.Timing;
import java.io.File;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;

public class GenerateLintFiles {
    private static final String ANDROID_JAR_PATTERN = "third_party/android_jar/lib-v%d/android.jar";
    private final DexItemFactory factory = new DexItemFactory();
    private final Reporter reporter = new Reporter();
    private final InternalOptions options = new InternalOptions(this.factory, this.reporter);
    private final MachineDesugaredLibrarySpecification desugaredLibrarySpecification;
    private final Path desugaredLibraryImplementation;
    private final Path outputDirectory;
    private final Set<DexMethod> parallelMethods = Sets.newIdentityHashSet();

    public GenerateLintFiles(String desugarConfigurationPath, String desugarImplementationPath, String outputDirectory) throws Exception {
        DesugaredLibrarySpecification specification = this.readDesugaredLibraryConfiguration(desugarConfigurationPath);
        Path androidJarPath = GenerateLintFiles.getAndroidJarPath(specification.getRequiredCompilationApiLevel());
        this.desugaredLibrarySpecification = specification.toMachineSpecification(this.options, androidJarPath, Timing.empty());
        this.desugaredLibraryImplementation = Paths.get(desugarImplementationPath, new String[0]);
        this.outputDirectory = Paths.get(outputDirectory, new String[0]);
        if (!Files.isDirectory(this.outputDirectory, new LinkOption[0])) {
            throw new Exception("Output directory " + outputDirectory + " is not a directory");
        }
        DexType streamType = this.factory.createType(this.factory.createString("Ljava/util/stream/Stream;"));
        DexMethod parallelMethod = this.factory.createMethod(this.factory.collectionType, this.factory.createProto(streamType, new DexType[0]), this.factory.createString("parallelStream"));
        this.parallelMethods.add(parallelMethod);
        DexType baseStreamType = this.factory.createType(this.factory.createString("Ljava/util/stream/BaseStream;"));
        for (String typePrefix : new String[]{"Base", "Double", "Int", "Long"}) {
            streamType = this.factory.createType(this.factory.createString("Ljava/util/stream/" + typePrefix + "Stream;"));
            parallelMethod = this.factory.createMethod(streamType, this.factory.createProto(streamType, new DexType[0]), this.factory.createString("parallel"));
            this.parallelMethods.add(parallelMethod);
            parallelMethod = this.factory.createMethod(streamType, this.factory.createProto(baseStreamType, new DexType[0]), this.factory.createString("parallel"));
            this.parallelMethods.add(parallelMethod);
        }
    }

    private static Path getAndroidJarPath(AndroidApiLevel apiLevel) {
        String jar = String.format(ANDROID_JAR_PATTERN, apiLevel.getLevel());
        return Paths.get(jar, new String[0]);
    }

    private DesugaredLibrarySpecification readDesugaredLibraryConfiguration(String desugarConfigurationPath) {
        return DesugaredLibrarySpecificationParser.parseDesugaredLibrarySpecification(StringResource.fromFile(Paths.get(desugarConfigurationPath, new String[0])), this.factory, this.reporter, false, AndroidApiLevel.B.getLevel());
    }

    private CfCode buildEmptyThrowingCfCode(DexMethod method) {
        CfInstruction[] insn = new CfInstruction[]{new CfConstNull(), new CfThrow()};
        return new CfCode(method.holder, 1, method.proto.parameters.size() + 1, Arrays.asList(insn));
    }

    private void addMethodsToHeaderJar(DexApplication.Builder builder, DexClass clazz, List<DexEncodedMethod> methods) {
        if (methods.size() == 0) {
            return;
        }
        ArrayList<DexEncodedMethod> directMethods = new ArrayList<DexEncodedMethod>();
        ArrayList<DexEncodedMethod> virtualMethods = new ArrayList<DexEncodedMethod>();
        for (DexEncodedMethod method : methods) {
            assert (method.getHolderType() == clazz.type);
            CfCode code = null;
            if (!method.accessFlags.isAbstract()) {
                code = this.buildEmptyThrowingCfCode((DexMethod)method.getReference());
            }
            DexEncodedMethod throwingMethod = DexEncodedMethod.builder().setMethod((DexMethod)method.getReference()).setAccessFlags(method.accessFlags).setGenericSignature(GenericSignature.MethodTypeSignature.noSignature()).setCode(code).setClassFileVersion(CfVersion.V1_6).disableAndroidApiLevelCheck().build();
            if (method.isStatic() || method.isDirectMethod()) {
                directMethods.add(throwingMethod);
                continue;
            }
            virtualMethods.add(throwingMethod);
        }
        DexEncodedMethod[] directMethodsArray = new DexEncodedMethod[directMethods.size()];
        DexEncodedMethod[] virtualMethodsArray = new DexEncodedMethod[virtualMethods.size()];
        directMethods.toArray(directMethodsArray);
        virtualMethods.toArray(virtualMethodsArray);
        assert (!this.options.encodeChecksums);
        DexProgramClass.ChecksumSupplier checksumSupplier = DexProgramClass::invalidChecksumRequest;
        DexProgramClass programClass = new DexProgramClass(clazz.type, null, Origin.unknown(), clazz.accessFlags, clazz.superType, clazz.interfaces, null, null, Collections.emptyList(), null, Collections.emptyList(), GenericSignature.ClassSignature.noSignature(), DexAnnotationSet.empty(), DexEncodedField.EMPTY_ARRAY, DexEncodedField.EMPTY_ARRAY, MethodCollection.MethodCollectionFactory.fromMethods(directMethodsArray, virtualMethodsArray), false, checksumSupplier);
        builder.addProgramClass(programClass);
    }

    private SupportedMethods collectSupportedMethods(AndroidApiLevel compilationApiLevel, Predicate<DexEncodedMethod> supported) throws Exception {
        AndroidApp library = AndroidApp.builder().addProgramFiles(GenerateLintFiles.getAndroidJarPath(compilationApiLevel)).build();
        DirectMappedDexApplication dexApplication = new ApplicationReader(library, this.options, Timing.empty()).read().toDirect();
        AndroidApp implementation = AndroidApp.builder().addProgramFiles(this.desugaredLibraryImplementation).build();
        DirectMappedDexApplication implementationApplication = new ApplicationReader(implementation, this.options, Timing.empty()).read().toDirect();
        Set<DexClass> classesWithAllMethodsSupported = Sets.newIdentityHashSet();
        LinkedHashMap<DexClass, List<DexEncodedMethod>> supportedMethods = new LinkedHashMap<DexClass, List<DexEncodedMethod>>();
        for (DexProgramClass clazz : dexApplication.classes()) {
            if (clazz.accessFlags.isPublic() && this.desugaredLibrarySpecification.getRewriteType().containsKey(clazz.type)) {
                DexProgramClass implementationClass = implementationApplication.programDefinitionFor(clazz.getType());
                if (implementationClass == null) {
                    throw new Exception("Implementation class not found for " + clazz.toSourceString());
                }
                boolean allMethodsAdded = true;
                for (DexEncodedMethod method2 : clazz.methods()) {
                    if (!method2.isPublic()) continue;
                    ProgramMethod implementationMethod = implementationClass.lookupProgramMethod((DexMethod)method2.getReference());
                    if (supported.test(method2) && implementationMethod != null) {
                        supportedMethods.computeIfAbsent(clazz, k -> new ArrayList()).add(method2);
                        continue;
                    }
                    allMethodsAdded = false;
                }
                if (allMethodsAdded) {
                    classesWithAllMethodsSupported.add(clazz);
                }
            }
            if (!this.desugaredLibrarySpecification.getEmulatedInterfaces().containsKey(clazz.type)) continue;
            assert (clazz.isInterface());
            for (DexEncodedMethod method3 : clazz.methods()) {
                if (!method3.isDefaultMethod() && !method3.isStatic() || !supported.test(method3)) continue;
                supportedMethods.computeIfAbsent(clazz, k -> new ArrayList()).add(method3);
            }
        }
        this.desugaredLibrarySpecification.forEachRetargetMethod(method -> {
            DexClass clazz = dexApplication.contextIndependentDefinitionFor(method.getHolderType());
            assert (clazz != null);
            DexEncodedMethod encodedMethod = clazz.lookupMethod((DexMethod)method);
            if (encodedMethod == null) {
                return;
            }
            if (supported.test(encodedMethod)) {
                supportedMethods.computeIfAbsent(clazz, k -> new ArrayList()).add(encodedMethod);
            }
        });
        return new SupportedMethods(classesWithAllMethodsSupported, supportedMethods);
    }

    private String lintBaseFileName(AndroidApiLevel compilationApiLevel, AndroidApiLevel minApiLevel) {
        return "desugared_apis_" + compilationApiLevel.getLevel() + "_" + minApiLevel.getLevel();
    }

    private Path lintFile(AndroidApiLevel compilationApiLevel, AndroidApiLevel minApiLevel, String extension) throws Exception {
        Path directory = this.outputDirectory.resolve("compile_api_level_" + compilationApiLevel.getLevel());
        Files.createDirectories(directory, new FileAttribute[0]);
        return Paths.get(directory + File.separator + this.lintBaseFileName(compilationApiLevel, minApiLevel) + extension, new String[0]);
    }

    private void writeLintFiles(AndroidApiLevel compilationApiLevel, AndroidApiLevel minApiLevel, SupportedMethods supportedMethods) throws Exception {
        ArrayList<String> desugaredApisSignatures = new ArrayList<String>();
        LazyLoadedDexApplication.Builder builder = DexApplication.builder(this.options, Timing.empty());
        supportedMethods.supportedMethods.forEach((clazz, methods) -> {
            String classBinaryName = DescriptorUtils.getClassBinaryNameFromDescriptor(clazz.type.descriptor.toString());
            if (!supportedMethods.classesWithAllMethodsSupported.contains(clazz)) {
                for (DexEncodedMethod method : methods) {
                    if (method.isInstanceInitializer() || method.isClassInitializer()) continue;
                    desugaredApisSignatures.add(classBinaryName + '#' + ((DexMethod)method.getReference()).name + ((DexMethod)method.getReference()).proto.toDescriptorString());
                }
            } else {
                desugaredApisSignatures.add(classBinaryName);
            }
            this.addMethodsToHeaderJar(builder, (DexClass)clazz, (List<DexEncodedMethod>)methods);
        });
        desugaredApisSignatures.sort(Comparator.naturalOrder());
        FileUtils.writeTextFile(this.lintFile(compilationApiLevel, minApiLevel, ".txt"), desugaredApisSignatures);
        AppView<AppInfo> appView = AppView.createForD8(AppInfo.createInitialAppInfo(builder.build()));
        CfApplicationWriter writer = new CfApplicationWriter(appView, this.options.getMarker(Marker.Tool.L8), NamingLens.getIdentityLens());
        ClassFileConsumer.ArchiveConsumer consumer = new ClassFileConsumer.ArchiveConsumer(this.lintFile(compilationApiLevel, minApiLevel, ".jar"));
        writer.write(consumer);
        consumer.finished(this.options.reporter);
    }

    private void generateLintFiles(AndroidApiLevel compilationApiLevel, Predicate<AndroidApiLevel> generateForThisMinApiLevel, BiPredicate<AndroidApiLevel, DexEncodedMethod> supportedForMinApiLevel) throws Exception {
        System.out.print("  - generating for min API:");
        for (AndroidApiLevel minApiLevel : AndroidApiLevel.values()) {
            if (!generateForThisMinApiLevel.test(minApiLevel)) continue;
            System.out.print(" " + minApiLevel);
            SupportedMethods supportedMethods = this.collectSupportedMethods(compilationApiLevel, method -> supportedForMinApiLevel.test(minApiLevel, (DexEncodedMethod)method));
            this.writeLintFiles(compilationApiLevel, minApiLevel, supportedMethods);
        }
        System.out.println();
    }

    private void run() throws Exception {
        for (int apiLevel = AndroidApiLevel.Sv2.getLevel(); apiLevel >= this.desugaredLibrarySpecification.getRequiredCompilationApiLevel().getLevel(); --apiLevel) {
            System.out.println("Generating lint files for compile API " + apiLevel);
            this.run(apiLevel);
        }
    }

    private void generateClassHTML(PrintStream ps, DexClass clazz, boolean newClass, Predicate<DexEncodedField> fieldsFilter, Predicate<DexEncodedMethod> methodsFilter) {
        HTMLSourceBuilder builder = new HTMLSourceBuilder(clazz, newClass, this.parallelMethods);
        StreamSupport.stream(clazz.fields().spliterator(), false).filter(fieldsFilter).filter(field -> field.accessFlags.isPublic() || field.accessFlags.isProtected()).sorted(Comparator.comparing(DexEncodedField::toSourceString)).forEach(x$0 -> ((SourceBuilder)builder).addField(x$0));
        StreamSupport.stream(clazz.methods().spliterator(), false).filter(methodsFilter).filter(method -> (method.accessFlags.isPublic() || method.accessFlags.isProtected()) && !method.accessFlags.isBridge()).sorted(Comparator.comparing(DexEncodedMethod::toSourceString)).forEach(x$0 -> ((SourceBuilder)builder).addMethod(x$0));
        ps.println(builder);
    }

    private void generateDesugaredLibraryApisDocumetation() throws Exception {
        PrintStream ps = new PrintStream(Files.newOutputStream(this.outputDirectory.resolve("apis.html"), new OpenOption[0]));
        SupportedMethods supportedMethods = this.collectSupportedMethods(AndroidApiLevel.Q, x -> true);
        supportedMethods.classesWithAllMethodsSupported.stream().sorted(Comparator.comparing(clazz -> clazz.type.toSourceString())).forEach(clazz -> this.generateClassHTML(ps, (DexClass)clazz, true, field -> true, method -> true));
        supportedMethods.supportedMethods.keySet().stream().filter(clazz -> !supportedMethods.classesWithAllMethodsSupported.contains(clazz)).sorted(Comparator.comparing(clazz -> clazz.type.toSourceString())).forEach(clazz -> this.generateClassHTML(ps, (DexClass)clazz, false, field -> false, method -> supportedMethods.supportedMethods.get(clazz).contains(method)));
    }

    public static void main(String[] args2) throws Exception {
        if (args2.length == 3) {
            new GenerateLintFiles(args2[0], args2[1], args2[2]).run();
            return;
        }
        if (args2.length == 4 && args2[0].equals("--generate-api-docs")) {
            new GenerateLintFiles(args2[1], args2[2], args2[3]).generateDesugaredLibraryApisDocumetation();
            return;
        }
        throw new RuntimeException(StringUtils.joinLines("Invalid invocation.", "Usage: GenerateLineFiles [--generate-api-docs] <desugar configuration> <desugar implementation> <output directory>"));
    }

    public void run(int apiLevel) throws Exception {
        this.generateLintFiles(AndroidApiLevel.getAndroidApiLevel(apiLevel), minApiLevel -> minApiLevel == AndroidApiLevel.L || minApiLevel == AndroidApiLevel.B, (minApiLevel, method) -> {
            assert (minApiLevel == AndroidApiLevel.L || minApiLevel == AndroidApiLevel.B);
            if (minApiLevel == AndroidApiLevel.L) {
                return true;
            }
            assert (minApiLevel == AndroidApiLevel.B);
            return !this.parallelMethods.contains(method.getReference());
        });
    }

    public static class HTMLSourceBuilder
    extends SourceBuilder<HTMLSourceBuilder> {
        private final Set<DexMethod> parallelMethods;

        public HTMLSourceBuilder(DexClass clazz, boolean newClass, Set<DexMethod> parallelMethods) {
            super(clazz, newClass);
            this.parallelMethods = parallelMethods;
        }

        @Override
        public HTMLSourceBuilder self() {
            return this;
        }

        public String toString() {
            HTMLBuilder builder = new HTMLBuilder();
            builder.start("tr");
            if (this.packageName.length() > 0) {
                builder.appendTdCode(this.packageName);
            }
            builder.appendTdCode(this.typeInPackage(this.className));
            builder.start("td").start("ul");
            if (!this.fields.isEmpty()) {
                assert (this.newClass);
                for (DexEncodedField field : this.fields) {
                    builder.appendLiCode(this.accessFlags(field.accessFlags) + " " + this.typeInPackage(((DexField)field.getReference()).type) + " " + ((DexField)field.getReference()).name);
                }
            }
            if (!this.constructors.isEmpty()) {
                for (Object constructor : this.constructors) {
                    builder.appendLiCode(this.accessFlags(((DexEncodedMethod)constructor).accessFlags) + " " + this.typeInPackage(this.className) + this.arguments((DexEncodedMethod)constructor));
                }
            }
            ArrayList<String> parallelM = new ArrayList<String>();
            if (!this.methods.isEmpty()) {
                for (DexEncodedMethod method : this.methods) {
                    builder.appendLiCode(this.accessFlags(method.accessFlags) + " " + this.typeInPackage(((DexMethod)method.getReference()).proto.returnType) + " " + ((DexMethod)method.getReference()).name + this.arguments(method));
                    if (!this.parallelMethods.contains(method.getReference())) continue;
                    parallelM.add(((DexMethod)method.getReference()).name.toString());
                }
            }
            builder.end("ul").end("td");
            StringBuilder commentBuilder = new StringBuilder();
            if (this.newClass) {
                commentBuilder.append("Fully implemented class.");
            } else {
                commentBuilder.append("Additional methods on existing class.");
            }
            if (!parallelM.isEmpty()) {
                commentBuilder.append(this.newClass ? "" : "<br>");
                if (parallelM.size() == 1) {
                    commentBuilder.append("The method <code>").append((String)parallelM.get(0)).append("</code> is only supported from API level 21.");
                } else {
                    commentBuilder.append("The following methods are only supported from API level 21:<br>");
                    for (int i = 0; i < parallelM.size(); ++i) {
                        commentBuilder.append("<code>").append((String)parallelM.get(i)).append("</code><br>");
                    }
                }
            }
            builder.appendTdP(commentBuilder.toString());
            builder.end("tr");
            return builder.toString();
        }
    }

    private static class HTMLBuilder
    extends StringBuilderWithIndent {
        private String indent = "";

        private HTMLBuilder() {
        }

        private void increaseIndent() {
            this.indent = this.indent + "  ";
            this.indent(this.indent);
        }

        private void decreaseIndent() {
            this.indent = this.indent.substring(0, this.indent.length() - 2);
            this.indent(this.indent);
        }

        HTMLBuilder appendTdCode(String s2) {
            this.appendLine("<td><code>" + s2 + "</code></td>");
            return this;
        }

        HTMLBuilder appendTdP(String s2) {
            this.appendLine("<td><p>" + s2 + "</p></td>");
            return this;
        }

        HTMLBuilder appendLiCode(String s2) {
            this.appendLine("<li><code>" + s2 + "</code></li>");
            return this;
        }

        HTMLBuilder start(String tag) {
            this.appendLine("<" + tag + ">");
            this.increaseIndent();
            return this;
        }

        HTMLBuilder end(String tag) {
            this.decreaseIndent();
            this.appendLine("</" + tag + ">");
            return this;
        }
    }

    private static abstract class SourceBuilder<B extends SourceBuilder> {
        protected final DexClass clazz;
        protected final boolean newClass;
        protected List<DexEncodedField> fields = new ArrayList<DexEncodedField>();
        protected List<DexEncodedMethod> constructors = new ArrayList<DexEncodedMethod>();
        protected List<DexEncodedMethod> methods = new ArrayList<DexEncodedMethod>();
        String className;
        String packageName;

        private SourceBuilder(DexClass clazz, boolean newClass) {
            this.clazz = clazz;
            this.newClass = newClass;
            this.className = clazz.type.toSourceString();
            int index = this.className.lastIndexOf(46);
            this.packageName = index > 0 ? this.className.substring(0, index) : "";
        }

        private B addField(DexEncodedField field) {
            this.fields.add(field);
            return this.self();
        }

        private B addMethod(DexEncodedMethod method) {
            assert (!method.isClassInitializer());
            if (method.isInitializer()) {
                this.constructors.add(method);
            } else {
                this.methods.add(method);
            }
            return this.self();
        }

        public abstract B self();

        protected String typeInPackage(String typeName, String packageName) {
            if (typeName.startsWith(packageName) && typeName.length() > packageName.length() && typeName.charAt(packageName.length()) == '.' && typeName.indexOf(46, packageName.length() + 1) == -1) {
                return typeName.substring(packageName.length() + 1);
            }
            return null;
        }

        protected String typeInPackage(String typeName) {
            String result = this.typeInPackage(typeName, this.packageName);
            if (result == null) {
                result = this.typeInPackage(typeName, "java.lang");
            }
            if (result == null) {
                result = typeName;
            }
            return result.replace('$', '.');
        }

        protected String typeInPackage(DexType type) {
            if (type.isPrimitiveType()) {
                return type.toSourceString();
            }
            return this.typeInPackage(type.toSourceString());
        }

        protected String accessFlags(ClassAccessFlags accessFlags) {
            ArrayList<String> flags = new ArrayList<String>();
            if (accessFlags.isPublic()) {
                flags.add("public");
            }
            if (accessFlags.isProtected()) {
                flags.add("protected");
            }
            if (accessFlags.isPrivate()) {
                assert (false);
                flags.add("private");
            }
            if (accessFlags.isPackagePrivate()) {
                assert (false);
                flags.add("/* package */");
            }
            if (accessFlags.isAbstract() && !accessFlags.isInterface()) {
                flags.add("abstract");
            }
            if (accessFlags.isStatic()) {
                flags.add("static");
            }
            if (accessFlags.isFinal()) {
                flags.add("final");
            }
            return String.join((CharSequence)" ", flags);
        }

        protected String accessFlags(FieldAccessFlags accessFlags) {
            ArrayList<String> flags = new ArrayList<String>();
            if (accessFlags.isPublic()) {
                flags.add("public");
            }
            if (accessFlags.isProtected()) {
                flags.add("protected");
            }
            if (accessFlags.isPrivate()) {
                assert (false);
                flags.add("private");
            }
            if (accessFlags.isPackagePrivate()) {
                assert (false);
                flags.add("/* package */");
            }
            if (accessFlags.isStatic()) {
                flags.add("static");
            }
            if (accessFlags.isFinal()) {
                flags.add("final");
            }
            return String.join((CharSequence)" ", flags);
        }

        protected String accessFlags(MethodAccessFlags accessFlags) {
            ArrayList<String> flags = new ArrayList<String>();
            if (accessFlags.isPublic()) {
                flags.add("public");
            }
            if (accessFlags.isProtected()) {
                flags.add("protected");
            }
            if (accessFlags.isPrivate()) {
                assert (false);
                flags.add("private");
            }
            if (accessFlags.isPackagePrivate()) {
                assert (false);
                flags.add("/* package */");
            }
            if (accessFlags.isAbstract()) {
                flags.add("abstract");
            }
            if (accessFlags.isStatic()) {
                flags.add("static");
            }
            if (accessFlags.isFinal()) {
                flags.add("final");
            }
            return String.join((CharSequence)" ", flags);
        }

        public String arguments(DexEncodedMethod method) {
            DexProto proto = ((DexMethod)method.getReference()).proto;
            StringBuilder argsBuilder = new StringBuilder();
            boolean firstArg = true;
            int argIndex = method.isVirtualMethod() || method.accessFlags.isConstructor() ? 1 : 0;
            int argNumber = 0;
            argsBuilder.append("(");
            for (DexType type : proto.parameters.values) {
                if (!firstArg) {
                    argsBuilder.append(", ");
                }
                if (method.hasCode()) {
                    String name = "p" + argNumber;
                    for (CfCode.LocalVariableInfo localVariable : method.getCode().asCfCode().getLocalVariables()) {
                        if (localVariable.getIndex() != argIndex) continue;
                        assert (!localVariable.getLocal().name.toString().equals("this"));
                        name = localVariable.getLocal().name.toString();
                    }
                    argsBuilder.append(this.typeInPackage(type)).append(" ").append(name);
                } else {
                    argsBuilder.append(this.typeInPackage(type)).append(" p").append(argNumber);
                }
                firstArg = false;
                argIndex += type.isWideType() ? 2 : 1;
                ++argNumber;
            }
            argsBuilder.append(")");
            return argsBuilder.toString();
        }
    }

    private static class StringBuilderWithIndent {
        String NL = System.lineSeparator();
        StringBuilder builder = new StringBuilder();
        String indent = "";

        StringBuilderWithIndent() {
        }

        StringBuilderWithIndent indent(String indent) {
            this.indent = indent;
            return this;
        }

        StringBuilderWithIndent appendLine(String line) {
            this.builder.append(this.indent);
            this.builder.append(line);
            this.builder.append(this.NL);
            return this;
        }

        StringBuilderWithIndent emptyLine() {
            this.builder.append(this.NL);
            return this;
        }

        public String toString() {
            return this.builder.toString();
        }
    }

    public static class SupportedMethods {
        public final Set<DexClass> classesWithAllMethodsSupported;
        public final Map<DexClass, List<DexEncodedMethod>> supportedMethods;

        public SupportedMethods(Set<DexClass> classesWithAllMethodsSupported, Map<DexClass, List<DexEncodedMethod>> supportedMethods) {
            this.classesWithAllMethodsSupported = classesWithAllMethodsSupported;
            this.supportedMethods = supportedMethods;
        }
    }
}

