/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.GenerateMainDexListCommand;
import com.android.tools.r8.Keep;
import com.android.tools.r8.R8;
import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.experimental.graphinfo.GraphConsumer;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppServices;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.LazyLoadedDexApplication;
import com.android.tools.r8.graph.SubtypingInfo;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.EnqueuerFactory;
import com.android.tools.r8.shaking.MainDexInfo;
import com.android.tools.r8.shaking.MainDexListBuilder;
import com.android.tools.r8.shaking.RootSetUtils;
import com.android.tools.r8.shaking.WhyAreYouKeepingConsumer;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.SortingStringConsumer;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

@Keep
public class GenerateMainDexList {
    private final Timing timing = new Timing("maindex");
    private final InternalOptions options;

    public GenerateMainDexList(InternalOptions options) {
        this.options = options;
    }

    private void run(AndroidApp app, ExecutorService executor, SortingStringConsumer consumer) throws IOException {
        try {
            LazyLoadedDexApplication application = new ApplicationReader(app, this.options, this.timing).read(executor);
            this.traceMainDex(executor, application, MainDexInfo.none()).forEach(type -> consumer.accept(type.toBinaryName() + ".class", this.options.reporter));
            consumer.finished(this.options.reporter);
        }
        catch (ExecutionException e) {
            throw ExceptionUtils.unwrapExecutionException(e);
        }
    }

    public static List<String> run(GenerateMainDexListCommand command) throws CompilationFailedException {
        AndroidApp app = command.getInputApp();
        InternalOptions options = command.getInternalOptions();
        return GenerateMainDexList.runForTesting(app, options);
    }

    public static List<String> run(GenerateMainDexListCommand command, ExecutorService executor) throws CompilationFailedException {
        AndroidApp app = command.getInputApp();
        InternalOptions options = command.getInternalOptions();
        ArrayList<String> result = new ArrayList<String>();
        ExceptionUtils.withMainDexListHandler(command.getReporter(), () -> GenerateMainDexList.run(app, executor, options, result));
        return result;
    }

    static List<String> runForTesting(AndroidApp app, InternalOptions options) throws CompilationFailedException {
        ExecutorService executorService = ThreadUtils.getExecutorService(options);
        ArrayList<String> result = new ArrayList<String>();
        ExceptionUtils.withMainDexListHandler(options.reporter, () -> {
            try {
                GenerateMainDexList.run(app, executorService, options, result);
            }
            finally {
                executorService.shutdown();
            }
        });
        return result;
    }

    private static void run(AndroidApp app, ExecutorService executor, InternalOptions options, final List<String> result) throws IOException {
        new GenerateMainDexList(options).run(app, executor, new SortingStringConsumer(new StringConsumer.ForwardingConsumer(options.mainDexListConsumer){

            @Override
            public void accept(String string, DiagnosticsHandler handler) {
                result.add(string);
                super.accept(string, handler);
            }
        }));
    }

    public static void main(String[] args2) throws CompilationFailedException {
        GenerateMainDexListCommand.Builder builder = GenerateMainDexListCommand.parse(args2);
        GenerateMainDexListCommand command = (GenerateMainDexListCommand)builder.build();
        if (command.isPrintHelp()) {
            System.out.println(GenerateMainDexListCommand.USAGE_MESSAGE);
            return;
        }
        if (command.isPrintVersion()) {
            System.out.println("MainDexListGenerator main");
            return;
        }
        List<String> result = GenerateMainDexList.run(command);
        if (command.getMainDexListConsumer() == null) {
            result.forEach(System.out::println);
        }
    }

    public MainDexInfo traceMainDex(ExecutorService executor, DexApplication application, MainDexInfo existingMainDexInfo) throws ExecutionException {
        AppView<AppInfoWithClassHierarchy> appView = AppView.createForR8(application.toDirect(), existingMainDexInfo);
        appView.setAppServices(AppServices.builder(appView).build());
        MainDexListBuilder.checkForAssumedLibraryTypes(appView.appInfo());
        SubtypingInfo subtypingInfo = SubtypingInfo.create(appView);
        RootSetUtils.MainDexRootSet mainDexRootSet = RootSetUtils.MainDexRootSet.builder(appView, subtypingInfo, this.options.mainDexKeepRules).build(executor);
        appView.setMainDexRootSet(mainDexRootSet);
        GraphConsumer graphConsumer = this.options.mainDexKeptGraphConsumer;
        WhyAreYouKeepingConsumer whyAreYouKeepingConsumer = null;
        if (!mainDexRootSet.reasonAsked.isEmpty()) {
            whyAreYouKeepingConsumer = new WhyAreYouKeepingConsumer(graphConsumer);
            graphConsumer = whyAreYouKeepingConsumer;
        }
        Enqueuer enqueuer = EnqueuerFactory.createForGenerateMainDexList(appView, executor, subtypingInfo, graphConsumer);
        MainDexInfo mainDexInfo = enqueuer.traceMainDex(executor, this.timing);
        R8.processWhyAreYouKeepingAndCheckDiscarded(mainDexRootSet, () -> {
            ArrayList classes = new ArrayList();
            mainDexInfo.forEach(type -> {
                DexClass clazz = appView.definitionFor((DexType)type);
                assert (clazz.isProgramClass());
                classes.add(clazz.asProgramClass());
            });
            return classes;
        }, whyAreYouKeepingConsumer, appView, enqueuer, true, this.options, this.timing, executor);
        return mainDexInfo;
    }
}

