/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCompilerCommandParser;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.D8CommandParser;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.L8;
import com.android.tools.r8.L8Command;
import com.android.tools.r8.OutputMode;
import com.android.tools.r8.StringResource;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.FlagFile;
import com.android.tools.r8.utils.StringDiagnostic;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Set;

public class L8CommandParser
extends BaseCompilerCommandParser<L8Command, L8Command.Builder> {
    private static final Set<String> OPTIONS_WITH_PARAMETER = ImmutableSet.of("--output", "--lib", "--min-api", "--desugared-lib", "--thread-count", "--pg-conf", new String[]{"--pg-map-output"});
    static final String USAGE_MESSAGE = String.join((CharSequence)"\n", Iterables.concat(Arrays.asList("Usage: l8 [options] <input-files>", " where <input-files> are any combination of dex, class, zip, jar, or apk files", " and options are:", "  --debug                 # Compile with debugging information (default).", "  --release               # Compile without debugging information.", "  --output <file>         # Output result in <outfile>.", "                          # <file> must be an existing directory or a zip file.", "  --lib <file|jdk-home>   # Add <file|jdk-home> as a library resource.", "  --min-api <number>      # Minimum Android API level compatibility, default: " + AndroidApiLevel.getDefault().getLevel() + ".", "  --pg-conf <file>        # Proguard configuration <file>.", "  --pg-map-output <file>  # Output the resulting name and line mapping to <file>.", "  --desugared-lib <file>  # Specify desugared library configuration.", "                          # <file> is a desugared library configuration (json)."), ASSERTIONS_USAGE_MESSAGE, THREAD_COUNT_USAGE_MESSAGE, MAP_DIAGNOSTICS_USAGE_MESSAGE, Arrays.asList("  --version               # Print the version of l8.", "  --help                  # Print this message.")));

    public static void main(String[] args2) throws CompilationFailedException {
        L8Command command = (L8Command)L8CommandParser.parse(args2, Origin.root()).build();
        if (command.isPrintHelp()) {
            System.out.println(USAGE_MESSAGE);
        } else {
            L8.run(command);
        }
    }

    public static L8Command.Builder parse(String[] args2, Origin origin) {
        return new L8CommandParser().parse(args2, origin, L8Command.builder());
    }

    public static L8Command.Builder parse(String[] args2, Origin origin, DiagnosticsHandler handler) {
        return new L8CommandParser().parse(args2, origin, L8Command.builder(handler));
    }

    private L8Command.Builder parse(String[] args2, Origin origin, L8Command.Builder builder) {
        CompilationMode compilationMode = null;
        Path outputPath = null;
        OutputMode outputMode = OutputMode.DexIndexed;
        boolean hasDefinedApiLevel = false;
        D8CommandParser.OrderedClassFileResourceProvider.Builder classpathBuilder = D8CommandParser.OrderedClassFileResourceProvider.builder();
        String[] expandedArgs = FlagFile.expandFlagFiles(args2, builder::error);
        for (int i = 0; i < expandedArgs.length; ++i) {
            String arg = expandedArgs[i].trim();
            String nextArg = null;
            if (OPTIONS_WITH_PARAMETER.contains(arg)) {
                if (++i < expandedArgs.length) {
                    nextArg = expandedArgs[i];
                } else {
                    builder.error(new StringDiagnostic("Missing parameter for " + expandedArgs[i - 1] + ".", origin));
                    break;
                }
            }
            if (arg.length() == 0) continue;
            if (arg.equals("--help")) {
                builder.setPrintHelp(true);
                continue;
            }
            if (arg.equals("--version")) {
                builder.setPrintVersion(true);
                continue;
            }
            if (arg.equals("--debug")) {
                if (compilationMode == CompilationMode.RELEASE) {
                    builder.error(new StringDiagnostic("Cannot compile in both --debug and --release mode.", origin));
                    continue;
                }
                compilationMode = CompilationMode.DEBUG;
                continue;
            }
            if (arg.equals("--release")) {
                if (compilationMode == CompilationMode.DEBUG) {
                    builder.error(new StringDiagnostic("Cannot compile in both --debug and --release mode.", origin));
                    continue;
                }
                compilationMode = CompilationMode.RELEASE;
                continue;
            }
            if (arg.equals("--output")) {
                if (outputPath != null) {
                    builder.error(new StringDiagnostic("Cannot output both to '" + outputPath.toString() + "' and '" + nextArg + "'", origin));
                    continue;
                }
                outputPath = Paths.get(nextArg, new String[0]);
                continue;
            }
            if (arg.equals("--min-api")) {
                if (hasDefinedApiLevel) {
                    builder.error(new StringDiagnostic("Cannot set multiple --min-api options", origin));
                    continue;
                }
                L8CommandParser.parsePositiveIntArgument(builder::error, "--min-api", nextArg, origin, builder::setMinApiLevel);
                hasDefinedApiLevel = true;
                continue;
            }
            if (arg.equals("--lib")) {
                L8CommandParser.addLibraryArgument(builder, origin, nextArg);
                continue;
            }
            if (arg.equals("--pg-conf")) {
                builder.addProguardConfigurationFiles(Paths.get(nextArg, new String[0]));
                continue;
            }
            if (arg.equals("--pg-map-output")) {
                builder.setProguardMapOutputPath(Paths.get(nextArg, new String[0]));
                continue;
            }
            if (arg.equals("--desugared-lib")) {
                builder.addDesugaredLibraryConfiguration(StringResource.fromFile(Paths.get(nextArg, new String[0])));
                continue;
            }
            if (arg.equals("--classfile")) {
                outputMode = OutputMode.ClassFile;
                continue;
            }
            if (arg.equals("--thread-count")) {
                L8CommandParser.parsePositiveIntArgument(builder::error, "--thread-count", nextArg, origin, builder::setThreadCount);
                continue;
            }
            if (arg.startsWith("--")) {
                if (this.tryParseAssertionArgument(builder, arg, origin)) continue;
                int argsConsumed = this.tryParseMapDiagnostics(builder, arg, expandedArgs, i, origin);
                if (argsConsumed >= 0) {
                    i += argsConsumed;
                    continue;
                }
                argsConsumed = this.tryParseDump(builder, arg, expandedArgs, i, origin);
                if (argsConsumed >= 0) {
                    i += argsConsumed;
                    continue;
                }
                builder.error(new StringDiagnostic("Unknown option: " + arg, origin));
                continue;
            }
            builder.addProgramFiles(Paths.get(arg, new String[0]));
        }
        if (!classpathBuilder.isEmpty()) {
            builder.addClasspathResourceProvider(classpathBuilder.build());
        }
        if (compilationMode != null) {
            builder.setMode(compilationMode);
        }
        if (outputPath == null) {
            outputPath = Paths.get(".", new String[0]);
        }
        return (L8Command.Builder)builder.setOutput(outputPath, outputMode);
    }
}

