/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.algorithms.scc;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import com.android.tools.r8.utils.SetUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public class SCC<Node> {
    private int currentTime = 0;
    private final Reference2IntMap<Node> discoverTime = new Reference2IntOpenHashMap<Node>();
    private final Set<Node> unassignedSet = Sets.newIdentityHashSet();
    private final Deque<Node> unassignedStack = new ArrayDeque<Node>();
    private final Deque<Node> preorderStack = new ArrayDeque<Node>();
    private final List<Set<Node>> components = new ArrayList<Set<Node>>();
    private final Function<Node, Iterable<? extends Node>> successors;

    public SCC(Function<Node, Iterable<? extends Node>> successors) {
        this.successors = successors;
    }

    private void dfs(Node value) {
        this.discoverTime.put(value, this.currentTime++);
        this.unassignedSet.add(value);
        this.unassignedStack.push(value);
        this.preorderStack.push(value);
        for (Node successor : this.successors.apply(value)) {
            if (!this.discoverTime.containsKey(successor)) {
                this.dfs(successor);
                continue;
            }
            if (!this.unassignedSet.contains(successor)) continue;
            int discoverTimeOfPhi = this.discoverTime.getInt(successor);
            while (discoverTimeOfPhi < this.discoverTime.getInt(this.preorderStack.peek())) {
                this.preorderStack.pop();
            }
        }
        if (this.preorderStack.peek() == value) {
            Node member;
            Set component = SetUtils.newIdentityHashSet(this.unassignedStack.size());
            do {
                member = this.unassignedStack.pop();
                this.unassignedSet.remove(member);
                component.add(member);
            } while (member != value);
            this.components.add(component);
            this.preorderStack.pop();
        }
    }

    public List<Set<Node>> computeSCC(Node v) {
        assert (this.currentTime == 0);
        this.dfs(v);
        return this.components;
    }
}

